--[[
	リザルト画面
	blog: https://www.kasacontent.com/tag/modernchic/
]]
DEBUG = false
-- モジュール読み込み
main_state = require("main_state")
timer_util = require("timer_util")
PROPERTY = require("Result.lua.require.property").load(true)
-- ヘッダ読み込み
local header = require("Result.lua.require.header").load(7)
-- 基準点の作成
local function createBasePosition()
	local base = {}
	base.mainPosX = 0
	base.subPosX = 0
	base.scrollBarPosX = 0
	base.centerPosX = 700
	if PROPERTY.isMainmenuLeft() then
		base.mainPosX = 35
		base.subPosX = 1220
		base.scrollBarPosX = 1885
	elseif PROPERTY.isMainmenuRight() then
		base.mainPosX = 1220
		base.subPosX = 35
		base.scrollBarPosX = 7
	end
	return base
end

local function main()
	SOUND = require("Result.lua.require.sound")
	-- 基本定義読み込み
	MAIN = require("Root.define")
	CUSTOM = require("Root.define2")
	-- テキスト関連
	local textProperty = require("Result.lua.require.textproperty")
	local skin = {}
	CUSTOM.LOAD_HEADER(skin, header)
	-- 基準点
	local base = createBasePosition()
	skin.source =  {
		{id = 0, path = "Result/parts/ring.png"},
		{id = 1, path = "Result/parts/irmask/*.png"},
		{id = 2, path = "Result/parts/system.png"},
		{id = 3, path = "Result/parts/prepare.png"},
		{id = 4, path = "Result/parts/number.png"},
		{id = 5, path = "Result/parts/lamp.png"},
		{id = 6, path = "Result/parts/parts.png"},
		{id = 7, path = "Result/parts/rank/*.png"},
		{id = 8, path = "Result/parts/gauge/*.png"},
	}
	skin.font = textProperty.font
	skin.text = textProperty.text
	skin.image = {}
	skin.imageset = {}
	skin.value = {}
	skin.slider = {}
	skin.graph = {}
	skin.gauge = {}
	skin.gaugegraph = {}
	skin.judgegraph = {}
	skin.bpmgraph = {}
	skin.timingdistributiongraph = {}
	skin.customTimers = {}
	skin.customEvents = {}
	skin.destination = {}

	-- 背景
	do
		local path = skin_config.get_path("Result/lua/background.lua")
		local status, parts = pcall(function()
			return dofile(path).load()
		end)
		if status and parts then
			CUSTOM.ADD_ALL(skin.source, parts.source)
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.imageset, parts.imageset)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	-- 画面下にタイトル、アーティスト、ジャンル、難易度表名
	table.insert(skin.destination, {
		id = MAIN.IMAGE.BLACK, dst = {
			{x = 0, y = 0, w = 1920, h = 50},
		}
	})
	table.insert(skin.destination, {
		id = "bottomResult", dst = {
			{x = 1920 / 2, y = 10, w = 1300, h = 25},
		}
	})
	-- 中央部情報
	do
		local path = skin_config.get_path("Result/lua/centerinfo.lua")
		local status, parts = pcall(function()
			return dofile(path).load(base, 0)
		end)
		if status and parts then
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.value, parts.value)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	-- 通常メニュー
	do
		local path = skin_config.get_path("Result/lua/mainmenu.lua")
		local status, parts = pcall(function()
			return dofile(path).load(base, 0)
		end)
		if status and parts then
			skin.gauge = parts.gauge
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.value, parts.value)
			CUSTOM.ADD_ALL(skin.graph, parts.graph)
			CUSTOM.ADD_ALL(skin.customTimers, parts.customTimers)
			CUSTOM.ADD_ALL(skin.gaugegraph, parts.gaugegraph)
			CUSTOM.ADD_ALL(skin.judgegraph, parts.judgegraph)
			CUSTOM.ADD_ALL(skin.bpmgraph, parts.bpmgraph)
			CUSTOM.ADD_ALL(skin.timingdistributiongraph, parts.timingdistributiongraph)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	-- IRメニュー
	if PROPERTY.isIrmenuOn() and main_state.option(MAIN.OP.ONLINE) then
		local path = skin_config.get_path("Result/lua/irmenu.lua")
		local status, parts = pcall(function()
			return dofile(path).load(base)
		end)
		if status and parts then
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.imageset, parts.imageset)
			CUSTOM.ADD_ALL(skin.customTimers, parts.customTimers)
			CUSTOM.ADD_ALL(skin.value, parts.value)
			CUSTOM.ADD_ALL(skin.slider, parts.slider)
			CUSTOM.ADD_ALL(skin.graph, parts.graph)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	-- 事前準備
	-- main_state.option(293)は使えないっぽい
	if PROPERTY.isStartAnimationOn() then
		local path = skin_config.get_path("Result/lua/prepare.lua")
		local status, parts = pcall(function()
			return dofile(path).load()
		end)
		if status and parts then
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	-- バージョンチェック
	do
		local path = skin_config.get_path("Result/lua/versioncheck.lua")
		local status, parts = pcall(function()
			return dofile(path).load(header.ver)
		end)
		if status and parts then
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.customTimers, parts.customTimers)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	-- フェードアウト処理
	do
		local path = skin_config.get_path("Result/lua/fadeout.lua")
		local status, parts = pcall(function()
			return dofile(path).load()
		end)
		if status and parts then
			CUSTOM.ADD_ALL(skin.image, parts.image)
			CUSTOM.ADD_ALL(skin.destination, parts.destination)
		end
	end
	
	return skin
end

return{
	header = header,
	main = main
}