--[[
	これまでのプレイ状況と選択した曲のTOTAL値などを表示
	@author : KASAKO
--]]

-- 参考TOTAL値
-- 参考URL：http://nekokan.dyndns.info/~268/memo/total.html
local function calcTotal()
	local gauge
	local totalNotes = main_state.number(MAIN.NUM.TOTALNOTES)
	if totalNotes < 1 then
		gauge = 0
	elseif totalNotes < 400 then
		gauge = 200 + (totalNotes / 5)
	elseif totalNotes < 600 then
		gauge = 280 + ((totalNotes - 400) / 2.5)
	elseif totalNotes >= 600 then
		gauge = 360 + ((totalNotes - 600) / 5)
	end
	return gauge
end

local function load()
	local parts = {}
	local window_posx = 10
	local window_posy = 10
	
	parts.image = {
		{id = "info-frame", src = 5, x = 2401, y = 312, w = 429, h = 194},
		{id = "info-frame2", src = 5, x = 2100, y = 10, w = 180, h = 190},
		{id = "info-frame3", src = 5, x = 2100, y = 210, w = 270, h = 190},
		{id = "judge-veryeasy", src = 5, x = 2835, y = 320, w = 165, h = 16},
		{id = "judge-easy", src = 5, x = 2835, y = 336, w = 165, h = 16},
		{id = "judge-normal", src = 5, x = 2835, y = 352, w = 165, h = 16},
		{id = "judge-hard", src = 5, x = 2835, y = 368, w = 165, h = 16},
		{id = "judge-veryhard", src = 5, x = 2835, y = 384, w = 165, h = 16},
		{id = "loading", src = 5, x = 2100, y = 410, w = 130, h = 20},
		{id = "offline", src = 5, x = 2100, y = 430, w = 130, h = 20},
		{id = "complete", src = 5, x = 2100, y = 450, w = 130, h = 20},

		{id = "totalFrame", src = 5, x = 2800, y = 0, w = 186, h = 24},
		{id = "totalFrameInfoLow", src = 5, x = 2800, y = 24, w = 93, h = 16},
		{id = "totalFrameInfoHigh", src = 5, x = 2893, y = 24, w = 93, h = 16},
	}
	
	parts.value = {
		-- これまで叩いたノート数
		{id = "totalplaynotes", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 10, ref = 333},
		-- これまで叩いたピカグレ
		{id = "totalpgreat", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 10, ref = 33},
		-- これまで叩いたグレート
		{id = "totalgreat", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 10, ref = 34},
		-- これまで叩いたgood
		{id = "totalgood", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 10, ref = 35},
		-- これまで叩いたbad
		{id = "totalbad", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 10, ref = 36},
		-- これまで叩いたpoor
		{id = "totalpoor", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 10, ref = 37},
		-- 総ノート数
		{id = "totalnotes", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 4, ref = 74, align = 1},
		-- 曲の長さ（分）
		{id = "songlen-min", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 2, ref = 1163},
		-- 曲の長さ（秒）
		{id = "songlen-sec", src = 5, x = 2401, y = 525, w = 242, h = 15, divx = 11, digit = 2, ref = 1164},
		-- プレイ数
		{id = "playcount", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 4, ref = 77},
		-- TOTAL値
		{id = "total", src = 5, x = 2401, y = 510, w = 220, h = 15, divx = 10, digit = 4, ref = 368, align = 1},
		-- 現在のIR順位
		{id = "ir_rank", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 5, ref = 179},
		-- IR参加人数
		{id = "ir_totalplayer", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 5, ref = 180},
		-- IRクリアレート
		{id = "ir_clearrate", src = 5, x = 2401, y = 510, w = 220, h = 15, divx = 10, digit = 3, ref = 181},
		-- IR読み込み時間
		{id = "ir_uwt", src = 5, x = 2401, y = 510, w = 242, h = 15, divx = 11, digit = 3, ref = 220},
	}

	parts.graph = {}

	table.insert(parts.graph, {
		id = "gr_totalLow", src = 5, x = 2800, y = 58, w = 180, h = 18, angle = 0, value = function()
			local calcNum = calcTotal()
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			local dValue = (50 + (totalNum - calcNum) / 2) / 100
			if dValue >= 1 then
				return 0.99
			elseif dValue <= 0 then
				return 0.01
			else
				return dValue
			end
		end
	})
	table.insert(parts.graph, {
		id = "gr_totalHigh", src = 5, x = 2800, y = 40, w = 180, h = 18, angle = 0, value = function()
			local calcNum = calcTotal()
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			-- 偏差値
			return (50 + (totalNum - calcNum) / 2) / 100
		end
	})
	
	-- op 2 : OPTION_SONGBAR
	-- op 180 : OPTION_JUDGE_VERYHARD
	-- op 181: OPTION_JUDGE_HARD
	-- op 182 : OPTION_JUDGE_NORMAL
	-- op 183 : OPTION_JUDGE_EASY
	-- op 184 : OPTION_JUDGE_VERYEASY
	parts.destination = {}

	table.insert(parts.destination, {
		id = "info-frame", dst = {
			{x = window_posx, y = window_posy, w = 429, h = 194},
		}
	})
	table.insert(parts.destination, {
		id = "info-frame2", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 7, y = window_posy + 2, w = 180, h = 190},
		}
	})
	table.insert(parts.destination, {
		id = "totalplaynotes", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 200, y = window_posy + 166, w = 22, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "totalpgreat", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 200, y = window_posy + 136, w = 22, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "totalgreat", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 200, y = window_posy + 104, w = 22, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "totalgood", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 200, y = window_posy + 73, w = 22, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "totalbad", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 200, y = window_posy + 41, w = 22, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "totalpoor", op = {-MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 200, y = window_posy + 11, w = 22, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "info-frame3", op = {MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 7, y = window_posy + 2, w = 270, h = 190},
		}
	})
	table.insert(parts.destination, {
		id = "totalnotes", op = {MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 140, y = window_posy + 167, w = 20, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "songlen-min", op = {MAIN.OP.SONGBAR}, dst = {
			{ x = window_posx + 140, y = window_posy + 105, w = 20, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "songlen-sec", op = {MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 203, y = window_posy + 105, w = 20, h = 15},
		}
	})
	table.insert(parts.destination, {
		id = "playcount", op = {MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 140, y = window_posy + 75, w = 20, h = 15},
		}
	})
	-- トータルゲージ計算機の値からのズレで色を変化させる
	-- 計算値より高い：かんたん
	table.insert(parts.destination, {
		id = "total", draw = function()
			local calcNum = calcTotal() - 20
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNum < totalNum)
		end, dst = {
			{x = window_posx + 140, y = window_posy + 136, w = 20, h = 15, r = 0, g = 120, b = 255},
		}
	})
	-- 計算値より低い：難しい
	table.insert(parts.destination, {
		id = "total", draw = function()
			local calcNum = calcTotal() + 20
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNum >= totalNum)
		end, dst = {
			{x = window_posx + 140, y = window_posy + 136, w = 20, h = 15, r = 255, g = 120, b = 0},
		}
	})
	-- 計算値より-20 ~ +20：ふつう
	table.insert(parts.destination, {
		id = "total", draw = function()
			local calcNumMin = calcTotal() - 20
			local calcNumMax = calcTotal() + 20
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNumMin <= totalNum) and (calcNumMax >= totalNum)
		end, dst = {
			{x = window_posx + 140, y = window_posy + 136, w = 20, h = 15},
		}
	})

	-- totalグラフ
	table.insert(parts.destination, {
		id = "totalFrame", op = {MAIN.OP.SONGBAR}, dst = {
			{x = window_posx + 230, y = window_posy + 133, w = 186, h = 24},
		}
	})
	table.insert(parts.destination, {
		id = "gr_totalLow", blend = MAIN.BLEND.ADDITION, draw = function()
			local calcNum = calcTotal()
			local totalNum = main_state.number(368)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNum >= totalNum)
		end, dst = {
			{x = window_posx + 233, y = window_posy + 136, w = 180, h = 18},
		}
	})
	table.insert(parts.destination, {
		id = "gr_totalHigh", blend = MAIN.BLEND.ADDITION, draw = function()
			local calcNum = calcTotal()
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNum < totalNum)
		end, dst = {
			{x = window_posx + 233, y = window_posy + 136, w = 180, h = 18},
		}
	})
	table.insert(parts.destination, {
		id = "totalFrameInfoLow", draw = function()
			local calcNum = calcTotal()
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNum >= totalNum)
		end, dst = {
			{x = window_posx + 276, y = window_posy + 138, w = 93, h = 16},
		}
	})
	table.insert(parts.destination, {
		id = "totalFrameInfoHigh", draw = function()
			local calcNum = calcTotal()
			local totalNum = main_state.number(MAIN.NUM.SONGGAUGE_TOTAL)
			return main_state.option(MAIN.OP.SONGBAR) and (calcNum < totalNum)
		end, dst = {
			{x = window_posx + 276, y = window_posy + 138, w = 93, h = 16},
		}
	})

	-- 判定レベル
	do
		local wd = {"veryeasy", "easy", "normal", "hard", "veryhard"}
		local op = {184, 183, 182, 181, 180}
		for i = 1, 5, 1 do
			table.insert(parts.destination, {
				id = "judge-" ..wd[i], op = {op[i], MAIN.OP.SONGBAR}, dst = {
					{x = window_posx + 140, y = window_posy + 43, w = 165, h = 16},
				}
			})
		end
	end
	-- IR読み込み時間
	table.insert(parts.destination, {
		id = "ir_uwt", op = {MAIN.OP.SONGBAR, MAIN.OP.ONLINE}, dst = {
			{x = window_posx + 225, y = window_posy + 11, w = 20, h = 15}
		}
	})
	-- IR読み込み完了
	table.insert(parts.destination, {
		id = "complete", op = {MAIN.OP.SONGBAR, MAIN.OP.IR_LOADED}, dst = {
			{x = window_posx + 225, y = window_posy + 11, w = 130, h = 20}
		}
	})
	-- オフライン時
	table.insert(parts.destination, {
		id = "offline", op = {MAIN.OP.SONGBAR, MAIN.OP.OFFLINE}, dst = {
			{x = window_posx + 215, y = window_posy + 9, w = 130, h = 20},
		}
	})
	return parts
end

return {
	load = load
}