--[[
	新バージョンがあるかどうかをチェックする
	@author : KASAKO
]]
local http = require("Result.lua.require.http")

local function load(version)
	local parts = {}

	-- スキンバージョンチェック
	local isNewVer = false
	
	if PROPERTY.isCheckNewVersionOn() then
		isNewVer = http.skinVersionCheck(version)
	end

	parts.image = {
		-- 新バージョン宣伝
		{id = "newVerionUpdate", src = 2, x = 260, y = 1910, w = 267, h = 40, divy = 2, cycle = 100},
		{id = "newVerionNone", src = 2, x = 260, y = 1950, w = 267, h = 20},
	}

	-- カスタムタイマー
	local exsistNewVersion = CUSTOM.GET_CUSTOMTIMER_ID()
	local versionCheckComplate = CUSTOM.GET_CUSTOMTIMER_ID()
	parts.customTimers = {
		{id = exsistNewVersion, timer = timer_util.timer_observe_boolean(function()
			if isNewVer == true then
				return true
			else
				return false
			end
		end)},
		{id = versionCheckComplate, timer = timer_util.timer_observe_boolean(function()
			if isNewVer ~= true then
				return true
			else
				return false
			end
		end)},
	}
	
	parts.destination = {}

	local posY = 6
	table.insert(parts.destination, {
		id = "newVerionUpdate", timer = exsistNewVersion, dst = {
			{x = 1920 - 277, y = posY, w = 267, h = 20},
		}
	})
	table.insert(parts.destination, {
		id = "newVerionNone", timer = versionCheckComplate, dst = {
			{x = 1920 - 277, y = posY, w = 267, h = 20},
		}
	})

	return parts
end

return {
	load = load
}