--[[
	プレイ情報部分
	@author : KASAKO
--]]

local function createTimingVisualizer(contents)
	local width = 300
	local judgeWidthMillis = nil
	local lineWidth = 1
	local lineColor = "00FF00FF"
	local centerColor = "FFFFFFFF"
	local PGColor = "000088FF"
	local GRColor = "008800FF"
	local GDColor = "888800FF"
	local BDColor = "880000FF"
	local PRColor = "000000FF"
	local transparent = 0
	local drawDecay = 1
	-- 倍率
	if PROPERTY.isTiminggraphMagnificationLow() then
		-- +-225ms
		judgeWidthMillis = 225
	elseif PROPERTY.isTiminggraphMagnificationNormal() then
		-- +-150ms
		judgeWidthMillis = 150
	elseif PROPERTY.isTiminggraphMagnificationHigh() then
		-- +-75ms
		judgeWidthMillis = 75
	end
	-- カラーパターン
	if PROPERTY.isTiminggraphColorRed() then
		lineColor = "E286A7FF"
		PGColor = "440000FF"
		GRColor = "990000FF"
		GDColor = "440000FF"
		BDColor = "990000FF"
		PRColor = "000000FF"
	elseif PROPERTY.isTiminggraphColorGreen() then
		lineColor = "86E088FF"
		PGColor = "004400FF"
		GRColor = "008800FF"
		GDColor = "004400FF"
		BDColor = "008800FF"
		PRColor = "000000FF"
	elseif PROPERTY.isTiminggraphColorBlue() then
		lineColor = "89DDDCFF"
		PGColor = "222244FF"
		GRColor = "222299FF"
		GDColor = "222244FF"
		BDColor = "222299FF"
		PRColor = "000000FF"
	end

	table.insert(contents, {
		id = "timing",
		width = width,
		judgeWidthMillis = judgeWidthMillis,
		lineWidth = lineWidth,
		lineColor = lineColor,
		centerColor = centerColor,
		PGColor = PGColor,
		GRColor = GRColor,
		GDColor = GDColor,
		BDColor = BDColor,
		PRColor = PRColor,
		transparent = transparent,
		drawDecay = drawDecay
	})
end

local function load()
	local parts = {}
	
	parts.image = {
		{id = "centerFrame", src = 1, x = 0, y = 0, w = 8, h = 900},
		{id = "bottomFrame", src = 1, x = 30, y = 758, w = 1164, h = 180},
		{id = "titleFrame", src = 1, x = 30, y = 20, w = 331, h = 92},
		{id = "artistFrame", src = 1, x = 30, y = 120, w = 331, h = 92},
		{id = "notesgraphFrame", src = 1, x = 380, y = 250, w = 331, h = 140},
		{id = "timinggraphFrame", src = 1, x = 380, y = 400, w = 331, h = 54},
		{id = "infoFrame", src = 1, x = 380, y = 20, w = 328, h = 225},

		{id = "bgaFrame1_1", src = 1, x = 30, y = 220, w = 331, h = 331},
		{id = "bgaFrame16_9", src = 1, x = 30, y = 560, w = 331, h = 191},

		{id = "soundOnly1_1", src = 1, x = 1100, y = 1140, w = 321, h = 321},
		{id = "soundOnly16_9", src = 1, x = 1100, y = 1208, w = 321, h = 181},
		
		-- SoundOnly
--		{id = "soundonly", src = 1, x = 570, y = 270, w = 600, h = 350},
		
		-- エフェクター
		{id = "effecter_nonactive", src = 1, x = 380, y = 560, w = 227, h = 28},
		{id = "effecter_active", src = 1, x = 610, y = 560, w = 227, h = 28},
		--LNタイプ
		{id = "btn-lnmode_nonactive", src = 1, x = 380, y = 588, w = 227, h = 84, divy = 3, len = 3, ref = MAIN.BUTTON.LNMODE},
		{id = "btn-lnmode_active", src = 1, x = 610, y = 588, w = 227, h = 84, divy = 3, len = 3, ref = MAIN.BUTTON.LNMODE},

		-- ノート分布カバー
		{id = "notesCover", src = 1, x = 0, y = 1270, w = 331, h = 140},
		-- タイミンググラフカバー
		{id = "timingCover", src = 1, x = 0, y = 1420, w = 331, h = 54},
		
		-- 修飾
		{id = "lamp_rhythm", src = 24, x = 0, y = 0, w = 152, h = 108},
		{id = "lamp_gaugeinclease", src = 24, x = 0, y = 0, w = 152, h = 216, divy = 2, cycle = 50, timer = MAIN.TIMER.GAUGE_INCLEASE_1P},
		{id = "lamp_maxgauge", src = 24, x = 0, y = 0, w = 152, h = 216, divy = 2, cycle = 50, timer = MAIN.TIMER.GAUGE_MAX_1P},
--		{id = "lamp_maxgauge", src = 24, x = 0, y = 0, w = 152, h = 108, timer = MAIN.TIMER.GAUGE_MAX_1P},

		-- 難易度画像
		{id = "lev_biginner", src = 1, x = 30, y = 940, w = 165, h = 20},
		{id = "lev_normal", src = 1, x = 30, y = 960, w = 165, h = 20},
		{id = "lev_hyper", src = 1, x = 30, y = 980, w = 165, h = 20},
		{id = "lev_another", src = 1, x = 30, y = 1000, w = 165, h = 20},
		{id = "lev_insame", src = 1, x = 30, y = 1020, w = 165, h = 20},
		{id = "lev_unknown", src = 1, x = 30, y = 1040, w = 165, h = 20},

		-- 使用オプション
		{id = "gaugeAssist", src = 1, x = 195, y = 940, w = 155, h = 20},
		{id = "gaugeEasy", src = 1, x = 195, y = 960, w = 155, h = 20},
		{id = "gaugeNormal", src = 1, x = 195, y = 980, w = 155, h = 20},
		{id = "gaugeHard", src = 1, x = 195, y = 1000, w = 155, h = 20},
		{id = "gaugeExHard", src = 1, x = 195, y = 1020, w = 155, h = 20},
		{id = "gaugeHazard", src = 1, x = 195, y = 1040, w = 155, h = 20},
		{id = "gaugeStandardGrade", src = 1, x = 380, y = 940, w = 155, h = 20},
		{id = "gaugeExGrade", src = 1, x = 380, y = 960, w = 155, h = 20},
		{id = "gaugeExHardGrade", src = 1, x = 380, y = 980, w = 155, h = 20},
		{id = "useOptionLeft", src = 1, x = 590, y = 940, w = 130, h = 200, divy = 10, len = 10, ref = MAIN.BUTTON.RANDOM_1P},
		{id = "useOptionRight", src = 1, x = 590, y = 940, w = 130, h = 200, divy = 10, len = 10, ref = MAIN.BUTTON.RANDOM_2P},
		-- タイミング調節ボタン
		{id = "timingAdjustBtn", src = 1, x = 529, y = 0, w = 1, h = 1, act = MAIN.BUTTON.JUDGE_TIMING}
	}
	
	parts.value = {
		-- 現在のスコア
		{id = "nowscore", src = 1, x = 1008, y = 940, w = 330, h = 40, divx = 11, divy = 1, digit = 6, ref = MAIN.NUM.POINT, zeropadding = MAIN.N_ZEROPADDING.ON},
		-- 現在の最大コンボ数
		{id = "maxcombo", src = 1, x = 1008, y = 940, w = 330, h = 40, divx = 11, divy = 1, digit = 5, ref = MAIN.NUM.MAXCOMBO2},
		-- 現在のEXスコア
		{id = "nowexscore", src = 1, x = 1008, y = 940, w = 330, h = 40, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.SCORE2, zeropadding = MAIN.N_ZEROPADDING.ON},
		
		-- 最大BPM
		{id = "maxbpm", src = 1, x = 1008, y = 980, w = 210, h = 40, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM, align = MAIN.N_ALIGN.CENTER},
		-- 現在のBPM
		{id = "nowbpm", src = 1, x = 1008, y = 940, w = 300, h = 40, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.NOWBPM, align = MAIN.N_ALIGN.CENTER},
		-- 最小BPM
		{id = "minbpm", src = 1, x = 1008, y = 980, w = 210, h = 40, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM, align = MAIN.N_ALIGN.CENTER},
		-- 残り時間
		{id = "min_time", src = 1, x = 720, y = 940, w = 264, h = 20, divx = 11, divy = 1, digit = 2, ref = MAIN.NUM.TIMELEFT_MINUTE},
		{id = "sec_time", src = 1, x = 720, y = 940, w = 264, h = 20, divx = 11, divy = 1, digit = 2, ref = MAIN.NUM.TIMELEFT_SECOND},
		-- 譜面レベル
		{id = "playlevel", src = 1, x = 720, y = 940, w = 264, h = 20, divx = 11, divy = 1, digit = 2, ref = MAIN.NUM.PLAYLEVEL},
		-- 総ノート
		{id = "totalNotes", src = 1, x = 720, y = 940, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.TOTALNOTES, align = MAIN.N_ALIGN.LEFT},
		-- PG数
		{id = "count_pg", src = 1, x = 720, y = 960, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.PERFECT, align = MAIN.N_ALIGN.RIGHT},
		-- great数
		{id = "count_gr", src = 1, x = 720, y = 960, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.GREAT, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_gr-early", src = 1, x = 720, y = 1100, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.EARLY_GREAT, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_gr-late", src = 1, x = 720, y = 1120, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.LATE_GREAT, align = MAIN.N_ALIGN.RIGHT},
		-- good数
		{id = "count_gd", src = 1, x = 720, y = 960, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.GOOD, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_gd-early", src = 1, x = 720, y = 1100, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.EARLY_GOOD, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_gd-late", src = 1, x = 720, y = 1120, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.LATE_GOOD, align = MAIN.N_ALIGN.RIGHT},
		-- bad数
		{id = "count_bd", src = 1, x = 720, y = 960, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.BAD, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_bd-early", src = 1, x = 720, y = 1100, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.EARLY_BAD, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_bd-late", src = 1, x = 720, y = 1120, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.LATE_BAD, align = MAIN.N_ALIGN.RIGHT},
		-- poor数
		{id = "count_pr", src = 1, x = 720, y = 960, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.POOR, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_pr-early", src = 1, x = 720, y = 1100, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.EARLY_POOR, align = MAIN.N_ALIGN.RIGHT},
		{id = "count_pr-late", src = 1, x = 720, y = 1120, w = 264, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.LATE_POOR, align = MAIN.N_ALIGN.RIGHT},
		-- judgetimingnumber
		{id = "judgeTimingNum", src = 1, x = 720, y = 1100, w = 288, h = 40, divx = 12, divy = 2, digit = 4, ref = MAIN.NUM.JUDGETIMING, zeropadding = MAIN.N_ZEROPADDING.OFF, align = MAIN.N_ALIGN.CENTER},
	}
	parts.timingvisualizer = {}
	createTimingVisualizer(parts.timingvisualizer)
	parts.destination = {}

	-- フレーム
	table.insert(parts.destination, {
		id = "centerFrame", dst = {
			{x = 897, y = 180, w = 126, h = 900},
		}
	})
	table.insert(parts.destination, {
		id = "bottomFrame", dst = {
			{x = 378, y = 0, w = 1164, h = 180},
		}
	})
	do
		local RGB = COMMONFUNC.setRGB()
		do
			-- タイトル
			local posx = 10
			local posy = 969
			table.insert(parts.destination, {
				id = "titleFrame", dst = {
					{x = posx, y = posy, w = 331, h = 92},
				}
			})
			table.insert(parts.destination, {
				id = "title", loop = 0, dst = {
					{time = 0, x = (posx + 10) + 311 / 2, y = posy + 25, w = 311, h = 25, r = RGB[1], g = RGB[2], b = RGB[3], a = 0},
					{time = 2000, a = 255},
					{time = 7000},
					{time = 9000, a = 0},
					{time = 18000},
				}
			})
			table.insert(parts.destination, {
				id = "genre", loop = 0, dst = {
					{time = 9000, x = (posx + 10) + 311 / 2, y = posy + 25, w = 311, h = 25, r = RGB[1], g = RGB[2], b = RGB[3], a = 0},
					{time = 11000, a = 255},
					{time = 16000},
					{time = 18000, a = 0},
				}
			})
		end
		do
			local posx = 1579
			local posy = 969
			table.insert(parts.destination, {
				id = "artistFrame", dst = {
					{x = posx, y = posy, w = 331, h = 92},
				}
			})
			table.insert(parts.destination, {
				id = "artist", dst = {
					{x = (posx + 10) + 311 / 2, y = posy + 25, w =  311, h = 25, r = RGB[1], g = RGB[2], b = RGB[3]},
				}
			})
		end
	end
	do
		local posx = 1579
		local posy = 5
		table.insert(parts.destination, {
			id = "infoFrame", dst = {
				{x = posx, y = posy, w = 328, h = 225},
			}
		})
		-- 時間（残り時間60秒で色が変化）
		table.insert(parts.destination, {
			id = "min_time",
			draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) >= 60
			end,
			dst = {
				{x = posx + 82, y = posy + 200, w = 20, h = 20},
			}
		})
		table.insert(parts.destination, {
			id = "sec_time",
			draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) >= 60
			end,
			dst = {
				{x = posx + 140, y = posy + 200, w = 20, h = 20},
			}
		})
		table.insert(parts.destination, {
			id = "min_time",
			draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) < 60
			end,
			dst = {
				{x = posx + 82, y = posy + 200, w = 20, h = 20, r = 253, g = 126, b = 0},
			}
		})
		table.insert(parts.destination, {
			id = "sec_time",
			draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) < 60
			end,
			dst = {
				{x = posx + 140, y = posy + 200, w = 20, h = 20, r = 253, g = 126, b = 0},
			}
		})
		-- 総ノート
		table.insert(parts.destination, {
			id = "totalNotes", dst = {
				{x = posx + 77, y = posy + 168, w = 20, h = 20},
			}
		})
		-- 判定カウンタ
		for i = 1, 13, 1 do
			local wd = {"pg","gr", "gr-early", "gr-late", "gd", "gd-early", "gd-late", "bd", "bd-early", "bd-late", "pr", "pr-early", "pr-late"}
			local adjustx = {77, 77, 160, 244, 77, 160, 244, 77, 160, 244, 77, 160, 244}
			local adjusty = {137, 106, 106, 106, 73, 73, 73, 41, 41, 41, 10, 10, 10}
			table.insert(parts.destination, {
				id = "count_"..wd[i], dst = {
					{x = posx + adjustx[i], y = posy + adjusty[i], w = 20, h = 20},
				}
			})
		end
	end
	-- BGAフレーム
	-- op1080: OPTION_STATE_PRACTICE
	if PROPERTY.isBgaPattern16_9() then
		local posx = {10, 10, 10, 1579, 1579, 1579}
		local posy = {760, 516, 272, 760, 516, 272}
		for i = 1, 6, 1 do
			table.insert(parts.destination, {
				id = "bgaFrame16_9", dst = {
					{x = posx[i], y = posy[i], w = 331, h = 191},
				}
			})
			table.insert(parts.destination, {
				id = "bga", op = {-MAIN.OP.STATE_PRACTICE, MAIN.OP.LOADED}, stretch = MAIN.STRETCH.FIT_OUTER_TRIMMED, dst = {
					{x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 181, a = 100},
				}
			})
			table.insert(parts.destination, {
				id = "bga", op = {-MAIN.OP.STATE_PRACTICE, MAIN.OP.LOADED}, dst = {
					{x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 181},
				}
			})
			-- bgaなし
			table.insert(parts.destination, {
				id = "soundOnly16_9", op = {MAIN.OP.NO_BGA}, dst = {
					{time = 0,x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 181},
					{time = 3000, a = 120},
					{time = 6000, a = 255}
				}
			})
			-- BGA明るさ調整
			table.insert(parts.destination,	{
				id = MAIN.IMAGE.BLACK, offsets = {PROPERTY.offsetBgaBrightness.num}, dst = {
					{x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 181, a = 0},
				}
			})
		end
	elseif PROPERTY.isBgaPattern1_1() then
		local posx = {10, 10, 1579, 1579}
		local posy = {620, 272, 620, 272}
		for i = 1, 4, 1 do
			table.insert(parts.destination, {
				id = "bgaFrame1_1", dst = {
					{x = posx[i], y = posy[i], w = 331, h = 331},
				}
			})
			table.insert(parts.destination, {
				id = "bga", op = {-MAIN.OP.STATE_PRACTICE, MAIN.OP.LOADED}, stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, dst = {
					{x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 321, a = 100},
				}
			})
			table.insert(parts.destination, {
				id = "bga", op = {-MAIN.OP.STATE_PRACTICE, MAIN.OP.LOADED}, dst = {
					{x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 321},
				}
			})
			-- bgaなし
			table.insert(parts.destination, {
				id = "soundOnly1_1", op = {MAIN.OP.NO_BGA}, dst = {
					{time = 0, x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 321},
					{time = 3000, a = 120},
					{time = 6000, a = 255}
				}
			})
			-- BGA明るさ調整
			table.insert(parts.destination,	{
				id = MAIN.IMAGE.BLACK, offsets = {PROPERTY.offsetBgaBrightness.num}, dst = {
					{x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 321, a = 0},
				}
			})
		end
	elseif PROPERTY.isNoBGA() then
		local posx = {10, 10, 1579, 1579}
		local posy = {620, 272, 620, 272}
		for i = 1, 4, 1 do
			table.insert(parts.destination, {
				id = "bgaFrame1_1", dst = {
					{x = posx[i], y = posy[i], w = 331, h = 331},
				}
			})
			table.insert(parts.destination, {
				id = "soundOnly1_1", dst = {
					{time = 0, x = posx[i] + 5, y = posy[i] + 5, w = 321, h = 321},
					{time = 3000, a = 120},
					{time = 6000, a = 255}
				}
			})
		end
		-- ポミュキャラ
--[[
		local pomyuPos = {10, 1579}
		for i = 1, 2, 1 do
			table.insert(parts.destination, {
				id = "dstPMchara1PBG", dst = {
					{x = pomyuPos[i] + (321 - 191) / 2, y = 282, w = 191, h = 310},
				}
			})
			table.insert(parts.destination, {
				id = "dstPMchara1P", dst = {
					{x = pomyuPos[i] + (321 - 191) / 2, y = 282, w = 191, h = 310},
				}
			})
		end
]]
	end
	-- エフェクター
	-- op172: LNが存在しない
	-- op173: LNが存在する
	if main_state.option(MAIN.OP.NO_LN) then
		table.insert(parts.destination,	{
			id = "effecter_nonactive", dst = {
				{x = 848, y = 6, w = 227, h = 28}
			}
		})
		table.insert(parts.destination,	{
			id = "effecter_active", timer = MAIN.TIMER.RHYTHM, dst = {
				{time = 0, x = 848, y = 6, w = 227, h = 28},
				{time = 1000, a = 50}
			}
		})
	elseif main_state.option(173) then
		table.insert(parts.destination,	{
			id = "btn-lnmode_nonactive", dst = {
				{x = 848, y = 6, w = 227, h = 28}
			}
		})
		table.insert(parts.destination,	{
			id = "btn-lnmode_active", timer = MAIN.TIMER.RHYTHM, dst = {
				{time = 0, x = 848, y = 6, w = 227, h = 28},
				{time = 1000, a = 50}
			}
		})
	end
	do
		local posx = 10
		local posy = 90
		-- ノート分布グラフ
		if PROPERTY.isnotesDistributionCoverOff() then
			table.insert(parts.destination, {
				id = "notesgraphFrame", dst = {
					{x = posx, y = posy, w = 331, h = 140},
				}
			})
			table.insert(parts.destination, {
				id = "judgegraph", dst = {
					{x = posx + 10, y = posy + 10, w = 311, h = 108},
				}
			})
			table.insert(parts.destination, {
				id = "bpmgraph", dst = {
					{x = posx + 10, y = posy + 10, w = 311, h = 108},
				}
			})
		elseif PROPERTY.isnotesDistributionCoverOn() then
			table.insert(parts.destination, {
				id = "notesCover", dst = {
					{x = posx, y = posy, w = 331, h = 140},
				}
			})
		end
	end

	do
		local posx = 10
		local posy = 23
		-- タイミンググラフ
		if PROPERTY.isTiminggraphCoverOff() then
		table.insert(parts.destination, {
			id = "timinggraphFrame", dst = {
				{x = posx, y = posy, w = 331, h = 54},
			}
		})
		table.insert(parts.destination, {
			id = "timing", dst = {
				{x = posx + 10, y = posy + 5, w = 311, h = 30},
			}
		})
		-- judgetimingnum
		table.insert(parts.destination, {
			id = "judgeTimingNum", dst = {
				{x = posx - 5, y = 60, w = 18, h = 15},
			}
		})
		table.insert(parts.destination, {
			id = "judgeTimingNum", dst = {
				{x = posx + 255, y = 60, w = 18, h = 15},
			}
		})
		-- タイミング調節ボタン
		table.insert(parts.destination, {
			id = "timingAdjustBtn", op = {}, dst = {
				{x = posx, y = posy, w = 331 , h = 54},
			}
		})
		elseif PROPERTY.isTiminggraphCoverOn() then
			table.insert(parts.destination, {
				id = "timingCover", dst = {
					{x = posx, y = posy, w = 331, h = 54},
				}
			})
		end
	end
	do
		-- 修飾
		local num = 2
		local posx = {360, 1386}
		local posy = 0
		for i = 1, num, 1 do
			table.insert(parts.destination,	{
				id = "lamp", dst = {
					{x = posx[i], y = posy, w = 152, h = 108}
				}
			})
			-- 修飾（リズムタイマー）
			-- op240: ゲージが100%
			-- op941: ゲージMAXインジケータ表示あり
			if PROPERTY.isGaugeMaxIndicatorOn() then
				table.insert(parts.destination,	{
					id = "lamp_rhythm", timer = MAIN.TIMER.RHYTHM, op = {-MAIN.OP.GAUGE_1P_100}, dst = {
						{time = 0, x = posx[i], y = posy, w = 152, h = 108},
						{time = 1000, a = 150}
					}
				})
				-- 修飾(ゲージMAX)
				table.insert(parts.destination,	{
					id = "lamp_maxgauge", timer = MAIN.TIMER.GAUGE_MAX_1P, dst = {
						{x = posx[i], y = posy, w = 152, h = 108}
					}
				})
			end
		end
	end

	-- 難易度
	do
		local wd = {"biginner", "normal", "hyper", "another", "insame", "unknown"}
		local op = {MAIN.OP.DIFFICULTY1, MAIN.OP.DIFFICULTY2, MAIN.OP.DIFFICULTY3, MAIN.OP.DIFFICULTY4, MAIN.OP.DIFFICULTY5, MAIN.OP.DIFFICULTY0}
		for i = 1, 6, 1 do
			table.insert(parts.destination, {
				id = "lev_"..wd[i], op = {op[i]}, dst = {
					{x = 400, y = 117, w = 165, h = 20}
				}
			})
		end
		table.insert(parts.destination, {
			id = "playlevel", dst = {
				{x = 635, y = 119, w = 24, h = 20},
			}
		})
	end

	-- 使用ゲージ＆オプション
	do
		local wd = {"Assist", "Easy", "Normal", "Hard", "ExHard", "Hazard", "StandardGrade", "ExGrade", "ExHardGrade"}
		for i = 1, 9, 1 do
			table.insert(parts.destination, {
				id = "gauge"..wd[i], draw = function()
					return main_state.gauge_type() == i - 1
				end,
				dst = {
					{x = 1224, y = 145, w = 155, h = 20},
				}
			})
		end
	end
	table.insert(parts.destination, {
		id = "useOptionLeft", dst = {
			{x = 1230, y = 117, w = 130, h = 20},
		}
	})
	table.insert(parts.destination, {
		id = "useOptionRight", dst = {
			{x = 1380, y = 117, w = 130, h = 20},
		}
	})

	-- 現在のスコア
	table.insert(parts.destination, {
		id = "nowscore", dst = {
			{x = 540, y = 39, w = 30, h = 40},
		}
	})
	-- 最大コンボ
	table.insert(parts.destination, {
		id = "maxcombo", dst = {
			{x = 1192, y = 39, w = 30, h = 40},
		}
	})
	-- BPM
	table.insert(parts.destination, {
		id = "minbpm", op = {MAIN.OP.BPMCHANGE}, dst = {
			{x = 790, y = 58, w = 21, h = 40},
		}
	})
	table.insert(parts.destination, {
		id = "nowbpm", dst = {
			{x = 902, y = 63, w = 30, h = 40},
		}
	})
	table.insert(parts.destination, {
		id = "maxbpm", op = {MAIN.OP.BPMCHANGE}, dst = {
			{x = 1048, y = 58, w = 21, h = 40},
		}
	})

	return parts
end

return {
	load = load
}