--[[
	爆発エフェクト
	@author : KASAKO
]]

local function load(base, keyNum)

	local bombCycle = 251
	local lnbombCycle = 160

	local parts = {}

	local init = {}
	local initLeft = {}
	local initRight = {}
	local bombTimerLeft = {}
	local bombTimerRight = {}
	local lnTimerLeft = {}
	local lnTimerRight = {}
	local bombTimer = {}
	local lnBombTimer = {}
	local modernchicLnPosY = {}
	local oadxLnPosY = {}
	local leftPostionX = {}
	local rightPostionX = {}
	local bombWidth
	local bombHeight
	local adjustPosY

	if keyNum == 10 then
		init = {"1", "2", "3", "4", "5", "sl", "6", "7", "8", "9", "10", "sr"}
		bombTimer = {MAIN.TIMER.BOMB_1P_KEY1, MAIN.TIMER.BOMB_1P_KEY2, MAIN.TIMER.BOMB_1P_KEY3, MAIN.TIMER.BOMB_1P_KEY4, MAIN.TIMER.BOMB_1P_KEY5, MAIN.TIMER.BOMB_1P_SCRATCH, MAIN.TIMER.BOMB_2P_KEY1, MAIN.TIMER.BOMB_2P_KEY2, MAIN.TIMER.BOMB_2P_KEY3, MAIN.TIMER.BOMB_2P_KEY4, MAIN.TIMER.BOMB_2P_KEY5, MAIN.TIMER.BOMB_2P_SCRATCH}
		lnBombTimer = {MAIN.TIMER.HOLD_1P_KEY1, MAIN.TIMER.HOLD_1P_KEY2, MAIN.TIMER.HOLD_1P_KEY3, MAIN.TIMER.HOLD_1P_KEY4, MAIN.TIMER.HOLD_1P_KEY5, MAIN.TIMER.HOLD_1P_SCRATCH, MAIN.TIMER.HOLD_2P_KEY1, MAIN.TIMER.HOLD_2P_KEY2, MAIN.TIMER.HOLD_2P_KEY3, MAIN.TIMER.HOLD_2P_KEY4, MAIN.TIMER.HOLD_2P_KEY5, MAIN.TIMER.HOLD_2P_SCRATCH}

		initLeft = {"1", "2", "3", "4", "5", "sl"}
		initRight = {"6", "7", "8", "9", "10", "sr"}
		bombTimerLeft = {MAIN.TIMER.BOMB_1P_KEY1, MAIN.TIMER.BOMB_1P_KEY2, MAIN.TIMER.BOMB_1P_KEY3, MAIN.TIMER.BOMB_1P_KEY4, MAIN.TIMER.BOMB_1P_KEY5, MAIN.TIMER.BOMB_1P_SCRATCH}
		bombTimerRight = {MAIN.TIMER.BOMB_2P_KEY1, MAIN.TIMER.BOMB_2P_KEY2, MAIN.TIMER.BOMB_2P_KEY3, MAIN.TIMER.BOMB_2P_KEY4, MAIN.TIMER.BOMB_2P_KEY5, MAIN.TIMER.BOMB_2P_SCRATCH}
		lnTimerLeft = {MAIN.TIMER.HOLD_1P_KEY1, MAIN.TIMER.HOLD_1P_KEY2, MAIN.TIMER.HOLD_1P_KEY3, MAIN.TIMER.HOLD_1P_KEY4, MAIN.TIMER.HOLD_1P_KEY5, MAIN.TIMER.HOLD_1P_SCRATCH}
		lnTimerRight = {MAIN.TIMER.HOLD_2P_KEY1, MAIN.TIMER.HOLD_2P_KEY2, MAIN.TIMER.HOLD_2P_KEY3, MAIN.TIMER.HOLD_2P_KEY4, MAIN.TIMER.HOLD_2P_KEY5, MAIN.TIMER.HOLD_2P_SCRATCH}
		if PROPERTY.isJudgeTimingBombOff() then
			modernchicLnPosY = {300, 600, 300, 600, 300, 900, 300, 600, 300, 600, 300, 900}
			oadxLnPosY = {192, 384, 192, 384, 192, 576, 192, 384, 192, 384, 192, 576}
		elseif PROPERTY.isJudgeTimingBombOn() then
			modernchicLnPosY = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
			oadxLnPosY = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
		end
		if PROPERTY.isModernChicBomb() then
			-- ボムの大きさ調整
			bombWidth, bombHeight, adjustPosY = COMMONFUNC.offsetBombSize(400, 300, 0, PROPERTY.offsetBombSize.width())
			-- ボム中心点
			leftPostionX = {144, 201, 258, 315, 372, 57}
			rightPostionX = {147, 204, 261, 318, 375, 462}
		elseif PROPERTY.isOADXBomb() then
			-- ボムの大きさ調整
			bombWidth, bombHeight, adjustPosY = COMMONFUNC.offsetBombSize(376, 300, 18, PROPERTY.offsetBombSize.width())
			-- ボム中心点
			leftPostionX = {167, 222, 282, 337, 397, 80}
			rightPostionX = {169, 225, 285, 340, 400, 484}
		end

	elseif keyNum == 14 then
		init = {"1", "2", "3", "4", "5", "6", "7", "sl", "8", "9", "10", "11", "12", "13", "14", "sr"}
		bombTimer = {MAIN.TIMER.BOMB_1P_KEY1, MAIN.TIMER.BOMB_1P_KEY2, MAIN.TIMER.BOMB_1P_KEY3, MAIN.TIMER.BOMB_1P_KEY4, MAIN.TIMER.BOMB_1P_KEY5, MAIN.TIMER.BOMB_1P_KEY6, MAIN.TIMER.BOMB_1P_KEY7, MAIN.TIMER.BOMB_1P_SCRATCH, MAIN.TIMER.BOMB_2P_KEY1, MAIN.TIMER.BOMB_2P_KEY2, MAIN.TIMER.BOMB_2P_KEY3, MAIN.TIMER.BOMB_2P_KEY4, MAIN.TIMER.BOMB_2P_KEY5, MAIN.TIMER.BOMB_2P_KEY6, MAIN.TIMER.BOMB_2P_KEY7, MAIN.TIMER.BOMB_2P_SCRATCH}
		lnBombTimer = {MAIN.TIMER.HOLD_1P_KEY1, MAIN.TIMER.HOLD_1P_KEY2, MAIN.TIMER.HOLD_1P_KEY3, MAIN.TIMER.HOLD_1P_KEY4, MAIN.TIMER.HOLD_1P_KEY5, MAIN.TIMER.HOLD_1P_KEY6, MAIN.TIMER.HOLD_1P_KEY7, MAIN.TIMER.HOLD_1P_SCRATCH, MAIN.TIMER.HOLD_2P_KEY1, MAIN.TIMER.HOLD_2P_KEY2, MAIN.TIMER.HOLD_2P_KEY3, MAIN.TIMER.HOLD_2P_KEY4, MAIN.TIMER.HOLD_2P_KEY5, MAIN.TIMER.HOLD_2P_KEY6, MAIN.TIMER.HOLD_2P_KEY7, MAIN.TIMER.HOLD_2P_SCRATCH}

		initLeft = {"1", "2", "3", "4", "5", "6", "7", "sl"}
		initRight = {"8", "9", "10", "11", "12", "13", "14", "sr"}
		bombTimerLeft = {MAIN.TIMER.BOMB_1P_KEY1, MAIN.TIMER.BOMB_1P_KEY2, MAIN.TIMER.BOMB_1P_KEY3, MAIN.TIMER.BOMB_1P_KEY4, MAIN.TIMER.BOMB_1P_KEY5, MAIN.TIMER.BOMB_1P_KEY6, MAIN.TIMER.BOMB_1P_KEY7, MAIN.TIMER.BOMB_1P_SCRATCH}
		bombTimerRight = {MAIN.TIMER.BOMB_2P_KEY1, MAIN.TIMER.BOMB_2P_KEY2, MAIN.TIMER.BOMB_2P_KEY3, MAIN.TIMER.BOMB_2P_KEY4, MAIN.TIMER.BOMB_2P_KEY5, MAIN.TIMER.BOMB_2P_KEY6, MAIN.TIMER.BOMB_2P_KEY7, MAIN.TIMER.BOMB_2P_SCRATCH}
		lnTimerLeft = {MAIN.TIMER.HOLD_1P_KEY1, MAIN.TIMER.HOLD_1P_KEY2, MAIN.TIMER.HOLD_1P_KEY3, MAIN.TIMER.HOLD_1P_KEY4, MAIN.TIMER.HOLD_1P_KEY5, MAIN.TIMER.HOLD_1P_KEY6, MAIN.TIMER.HOLD_1P_KEY7, MAIN.TIMER.HOLD_1P_SCRATCH}
		lnTimerRight = {MAIN.TIMER.HOLD_2P_KEY1, MAIN.TIMER.HOLD_2P_KEY2, MAIN.TIMER.HOLD_2P_KEY3, MAIN.TIMER.HOLD_2P_KEY4, MAIN.TIMER.HOLD_2P_KEY5, MAIN.TIMER.HOLD_2P_KEY6, MAIN.TIMER.HOLD_2P_KEY7, MAIN.TIMER.HOLD_2P_SCRATCH}
		if PROPERTY.isJudgeTimingBombOff() then
			modernchicLnPosY = {300, 600, 300, 600, 300, 600, 300, 900, 300, 600, 300, 600, 300, 600, 300, 900}
			oadxLnPosY = {192, 384, 192, 384, 192, 384, 192, 576, 192, 384, 192, 384, 192, 384, 192, 576}
		elseif PROPERTY.isJudgeTimingBombOn() then
			modernchicLnPosY = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
			oadxLnPosY = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
		end
		if PROPERTY.isModernChicBomb() then
			-- ボムの大きさ調整
			bombWidth, bombHeight, adjustPosY = COMMONFUNC.offsetBombSize(400, 300, 0, PROPERTY.offsetBombSize.width())
			-- ボム中心点
			leftPostionX = {144, 201, 258, 315, 372, 429, 486, 57}
			rightPostionX = {33, 90, 147, 204, 261, 318, 375, 462}
		elseif PROPERTY.isOADXBomb() then
			-- ボムの大きさ調整
			bombWidth, bombHeight, adjustPosY = COMMONFUNC.offsetBombSize(376, 300, 18, PROPERTY.offsetBombSize.width())
			-- ボム中心点
			leftPostionX = {167, 222, 282, 337, 397, 452, 512, 80}
			rightPostionX = {55, 110, 169, 225, 285, 340, 400, 484}
		end
	end
	
	parts.image = {}
	if PROPERTY.isModernChicBomb() then
		-- ModernChic規格ボム・通常
		table.insert(parts.image, {
			id = "bomb", src = 11, x = 0, y = 0, w = -1, h = -1
		})
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "bomb-"..init[i], src = 11, x = 0, y = 0, w = 6400, h = 300, divx = 16, divy = 1, cycle = bombCycle, timer = bombTimer[i]
			})
		end
		-- ModernChic規格ボム・LN
		table.insert(parts.image, {
			id = "lnbomb", src = 11, x = 0, y = 0, w = -1, h = -1
		})
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "lnbomb-"..init[i], src = 11, x = 0, y = modernchicLnPosY[i], w = 3200, h = 300, divx = 8, divy = 1, cycle = lnbombCycle, timer = lnBombTimer[i]
			})
		end
		-- ModernChic規格ボム・SLOW
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "slowbomb-"..init[i], src = 11, x = 0, y = 300, w = 6400, h = 300, divx = 16, divy = 1, cycle = bombCycle, timer = bombTimer[i]
			})
		end
		-- ModernChic規格ボム・FAST
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "fastbomb-"..init[i], src = 11, x = 0, y = 600, w = 6400, h = 300, divx = 16, divy = 1, cycle = bombCycle, timer = bombTimer[i]
			})
		end
	elseif PROPERTY.isOADXBomb() then
		-- OADX規格ボム・通常
		table.insert(parts.image, {
			id = "bomb", src = 28, x = 0, y = 0, w = -1, h = -1
		})
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "bomb-"..init[i], src = 28, x = 0, y = 0, w = 2896, h = 192, divx = 16, divy = 1, cycle = bombCycle, timer = bombTimer[i]
			})
		end
		-- OADX規格ボム・LN
		table.insert(parts.image, {
			id = "lnbomb", src = 28, x = 0, y = 0, w = -1, h = -1
		})
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "lnbomb-"..init[i], src = 28, x = 0, y = oadxLnPosY[i], w = 1448, h = 192, divx = 8, divy = 1, cycle = lnbombCycle, timer = lnBombTimer[i]
			})
		end
		-- OADX規格ボム・SLOW
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "slowbomb-"..init[i], src = 28, x = 0, y = 192, w = 2896, h = 192, divx = 16, divy = 1, cycle = bombCycle, timer = bombTimer[i]
			})
		end
		-- OADX規格ボム・FAST
		for i = 1, #init, 1 do
			table.insert(parts.image, {
				id = "fastbomb-"..init[i], src = 28, x = 0, y = 384, w = 2896, h = 192, divx = 16, divy = 1, cycle = bombCycle, timer = bombTimer[i]
			})
		end
	end
	
	parts.destination = {}
	-- ボム先読み
	table.insert(parts.destination,{
		id = "bomb", dst = {
			{x = 0, y = 0, w = 1, h = 1},
		}
	})
	table.insert(parts.destination,{
		id = "lnbomb", dst = {
			{x = 0, y = 0, w = 1, h = 1},
		}
	})
	
	-- 通常爆発エフェクトの配置
	if PROPERTY.isJudgeTimingBombOff() then
		for i = 1, #init / 2, 1 do
			-- 左 bomb-1 ~ bomb-sl
			table.insert(parts.destination, {
				id = "bomb-"..initLeft[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerLeft[i], blend = MAIN.BLEND.ADDITION, dst = {
					{time = 0, x = base.laneLeftPosX + leftPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
			-- 右 bomb-8 ~ bomb-sr
			table.insert(parts.destination, {
				id = "bomb-"..initRight[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerRight[i], blend = MAIN.BLEND.ADDITION, dst = {
					{time = 0, x = base.laneRightPosX + rightPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
		end
	elseif PROPERTY.isJudgeTimingBombOn() then
		-- 通常ボム
		for i = 1, #init / 2, 1 do
			-- 左 bomb-1 ~ bomb-sl
			table.insert(parts.destination, {
				id = "bomb-"..initLeft[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerLeft[i], blend = MAIN.BLEND.ADDITION, op = {-MAIN.OP.EARLY_1P, -MAIN.OP.LATE_1P}, dst = {
					{time = 0, x = base.laneLeftPosX + leftPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
			-- 右 bomb-8 ~ bomb-sr
			table.insert(parts.destination, {
				id = "bomb-"..initRight[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerRight[i], blend = MAIN.BLEND.ADDITION, op = {-MAIN.OP.EARLY_2P, -MAIN.OP.LATE_2P}, dst = {
					{time = 0, x = base.laneRightPosX + rightPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
		end
		-- op1242:OPTION_1P_FAST
		for i = 1, #init / 2, 1 do
			-- 左 fastbomb-1 ~ fastbomb-sl
			table.insert(parts.destination, {
				id = "fastbomb-"..initLeft[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerLeft[i], blend = MAIN.BLEND.ADDITION, op = {MAIN.OP.EARLY_1P}, dst = {
					{time = 0, x = base.laneLeftPosX + leftPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
			-- 右 fastbomb-8 ~ fastbomb-sr
			table.insert(parts.destination, {
				id = "fastbomb-"..initRight[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerRight[i], blend = MAIN.BLEND.ADDITION, op = {MAIN.OP.EARLY_2P}, dst = {
					{time = 0, x = base.laneRightPosX + rightPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
		end
		-- op1243:OPTION_1P_LATE
		for i = 1, #init / 2, 1 do
			-- 左 slowbomb-1 ~ slowbomb-sl
			table.insert(parts.destination, {
				id = "slowbomb-"..initLeft[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerLeft[i], blend = MAIN.BLEND.ADDITION, op = {MAIN.OP.LATE_1P}, dst = {
					{time = 0, x = base.laneLeftPosX + leftPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
			-- 右 slowbomb-8 ~ slowbomb-sr
			table.insert(parts.destination, {
				id = "slowbomb-"..initRight[i], offset = MAIN.OFFSET.LIFT, loop = -1, filter = MAIN.FILTER.ON, timer = bombTimerRight[i], blend = MAIN.BLEND.ADDITION, op = {MAIN.OP.LATE_2P}, dst = {
					{time = 0, x = base.laneRightPosX + rightPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
					{time = bombCycle - 1}
				}
			})
		end
	end
	-- LN爆発エフェクトの配置
	for i = 1, #init / 2, 1 do
		-- 左 lnbomb-1 ~ lnbomb-sl
		table.insert(parts.destination,	{
			id = "lnbomb-"..initLeft[i], offset = MAIN.OFFSET.LIFT, filter = MAIN.FILTER.ON, timer = lnTimerLeft[i], blend = MAIN.BLEND.ADDITION, dst = {
				{time = 0, x = base.laneLeftPosX + leftPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
				{time = lnbombCycle - 1}
			}
		})
		-- 右 lnbomb-8 ~ lnbomb-sr
		table.insert(parts.destination,	{
			id = "lnbomb-"..initRight[i], offset = MAIN.OFFSET.LIFT, filter = MAIN.FILTER.ON, timer = lnTimerRight[i], blend = MAIN.BLEND.ADDITION, dst = {
				{time = 0, x = base.laneRightPosX + rightPostionX[i] - bombWidth / 2, y = base.notesPositionY - adjustPosY - (bombHeight / 2), w = bombWidth, h = bombHeight},
				{time = lnbombCycle - 1}
			}
		})
	end
	
	return parts
end

return {
	load = load
}