--[[
	7鍵用メインLua
	@author : KASAKO
	blog: https://www.kasacontent.com/tag/modernchic/
]]
DEBUG = false
-- モジュール読み込み
main_state = require("main_state")
-- requireはディレクトリ区切りを.で表す
PROPERTY = require("Play.lua.require.sp_property").load(false)
COMMONFUNC = require("Play.lua.require.common")
-- ヘッダ読み込み
local header = require("Play.lua.require.header").load(0)
-- 基準点の作成
local function createBasePosition()
	-- 基準点
	local base = {}
	-- プレイ側レーン基準
	base.playsidePositionX = 0
	-- プログレスバー基準
	base.progressbarPositionX = 0
	-- サブ画面（タイトル、BGA,スコアなど）基準
	base.infoPositionX = 0
	-- ゲージ基準（ゲージ、レベル、判定カウント）
	base.gaugePositionX = 0
	base.keyPosition = {}
	base.keyflashPosX = {}
	-- 判定基準点
	base.notesPositionY = 227
	-- 基準点の設定
	if PROPERTY.isLeftPosition() then
		base.playsidePositionX = 51
		base.infoPositionX = 570
		base.progressbarPositionX = 23
		base.gaugePositionX = 14
	elseif PROPERTY.isRightPosition() then
		base.playsidePositionX = 1350
		base.infoPositionX = 0
		base.gaugePositionX = 1350
		base.progressbarPositionX = 1881
	end
	if PROPERTY.isLeftScratch() then
		base.keyPosition = {114, 177, 228, 291, 342, 405, 456, 3}
		base.keyflashPosX = {110, 167, 224, 281, 338, 395, 452}
	elseif PROPERTY.isRightScratch() then
		base.keyPosition = {3, 66, 117, 180, 231, 294, 345, 408}
		base.keyflashPosX = {-1, 56, 113, 170, 227, 284, 341}
	end

	return base
end

local function main()
	-- 基本定義読み込み
	MAIN = require("Root.define")
	CUSTOM = require("Root.define2")
	-- テキスト
	local textProperty = require("Play.lua.require.textproperty")
	local skin = {}
	CUSTOM.LOAD_HEADER(skin, header)

	local base = createBasePosition()
	
	skin.source =  {
		{id = 1, path = "Play/parts/sp_hw/system.png"},
		{id = 2, path = "Play/parts/sp_hw/info.png"},
		{id = 3, path = "Play/parts/common/bg/*.png"},
		{id = 4, path = "Play/parts/common/judge/*.png"},
		{id = 5, path = "Play/parts/common/judgeline/*.png"},
		{id = 6, path = "Play/parts/common/notes/*.png"},
		{id = 9, path = "Play/parts/common/glow/*.png"},
		{id = 10, path = "Play/parts/common/progress/*.png"},
		{id = 11, path = "Play/parts/common/bomb/*.png"},
		{id = 13, path = "Play/parts/common/fullcombo/*.png"},
		{id = 14, path = "Play/parts/common/keybeam/*.png"},
		{id = 15, path = "Play/parts/common/key/*.png"},
		{id = 16, path = "Play/parts/common/keyflash/*.png"},
		{id = 17, path = "Play/parts/sp_hw/lanecover/*.png"},
		{id = 18, path = "Play/parts/sp_hw/lift/*.png"},
		{id = 20, path = "Play/parts/sp_hw/bga.png"},
		{id = 21, path = "Play/parts/common/close/close.png"},
		{id = 22, path = "Play/parts/sp_hw/score.png"},
		{id = 24, path = "Play/parts/common/lamp/*.png"},
		{id = 25, path = "Play/parts/sp_hw/graphbg/*.png"},
		{id = 26, path = "Play/parts/common/mine/#default.png"},
		{id = 28, path = "Play/parts/common/oadx_bomb/*.png"},
		{id = 29, path = "Play/parts/common/gauge/*.png"},
		{id = 30, path = "Play/parts/common/scratch/*.png"},
	}
	-- BGAが用意されていないときのみ読み込む
	if main_state.option(MAIN.OP.NO_BGA) and PROPERTY.isHanyoTypeMovie() then
		table.insert(skin.source,{
			id = 23, path = "Play/parts/common/BGA/movie/*.mp4"
		})
	elseif main_state.option(MAIN.OP.NO_BGA) and PROPERTY.isHanyoTypeImage() then
		table.insert(skin.source,{
			id = 27, path = "Play/parts/common/BGA/image/*.png"
		})
	end

	skin.font = textProperty.font
	skin.text = textProperty.text
	skin.image = {}
	-- 各鍵盤の情報
	skin.note = {}
	skin.value = {}
	skin.slider = {}
	skin.hiddenCover = {}
	skin.liftCover = {}
	skin.graph = {}
	skin.bga = {id = "bga"}
	skin.judgegraph = {
		-- backTexOff 0：背景黒 1:背景を透過
		{id = "judgegraph", type = 1, backTexOff = 1},
	}
	skin.bpmgraph = {
		{id = "bpmgraph"}
	}
	skin.timingvisualizer = {}
	skin.judge = {}
	skin.gauge = {}
	skin.destination = {}
	
	-- 背景
	do
		local background_path = skin_config.get_path("Play/lua/background.lua")
		local background_status, background_parts = pcall(function()
			return dofile(background_path).load(3)
		end)
		if background_status and background_parts then
			CUSTOM.ADD_ALL(skin.image, background_parts.image)
			CUSTOM.ADD_ALL(skin.destination, background_parts.destination)
		end
	end
	-- インフォ部分
	do
		local info_path = skin_config.get_path("Play/lua/sp/info.lua")
		local info_status, info_parts = pcall(function()
			return dofile(info_path).load(base)
		end)
		if info_status and info_parts then
			CUSTOM.ADD_ALL(skin.image, info_parts.image)
			CUSTOM.ADD_ALL(skin.value, info_parts.value)
			CUSTOM.ADD_ALL(skin.graph, info_parts.graph)
			CUSTOM.ADD_ALL(skin.timingvisualizer, info_parts.timingvisualizer)
			CUSTOM.ADD_ALL(skin.destination, info_parts.destination)
		end
	end
	-- 進捗バー
	do
		local progress_path = skin_config.get_path("Play/lua/sp/progress.lua")
		local progress_status, progress_parts = pcall(function()
			return dofile(progress_path).load(base)
		end)
		if progress_status and progress_parts then
			CUSTOM.ADD_ALL(skin.image, progress_parts.image)
			CUSTOM.ADD_ALL(skin.slider, progress_parts.slider)
			CUSTOM.ADD_ALL(skin.destination, progress_parts.destination)
		end
	end
	-- キーフラッシュ
	do
		local keyflash_path = skin_config.get_path("Play/lua/sp/keyflash.lua")
		local keyflash_status, keyflash_parts = pcall(function()
			return dofile(keyflash_path).load(base, 7)
		end)
		if keyflash_status and keyflash_parts then
			CUSTOM.ADD_ALL(skin.image, keyflash_parts.image)
			CUSTOM.ADD_ALL(skin.destination, keyflash_parts.destination)
		end
	end
	-- ゲージ
	do
		local gauge_path = skin_config.get_path("Play/lua/sp/gauge.lua")
		local gauge_status, gauge_parts = pcall(function()
			return dofile(gauge_path).load(base)
		end)
		if gauge_status and gauge_parts then
			CUSTOM.ADD_ALL(skin.image, gauge_parts.image)
			CUSTOM.ADD_ALL(skin.value, gauge_parts.value)
			skin.gauge = gauge_parts.gauge
			CUSTOM.ADD_ALL(skin.destination, gauge_parts.destination)
		end
	end
	-- レーン部分
	do
		local lane_path = skin_config.get_path("Play/lua/sp/lane.lua")
		local lane_status, lane_parts = pcall(function()
			return dofile(lane_path).load(base)
		end)
		if lane_status and lane_parts then
			CUSTOM.ADD_ALL(skin.image, lane_parts.image)
			CUSTOM.ADD_ALL(skin.destination, lane_parts.destination)
		end
	end
	-- キー入力
	do
		local inputkey_path = skin_config.get_path("Play/lua/sp/inputkey.lua")
		local inputkey_status, inputkey_parts = pcall(function()
			return dofile(inputkey_path).load(base, 7)
		end)
		if inputkey_status and inputkey_parts then
			CUSTOM.ADD_ALL(skin.image, inputkey_parts.image)
			CUSTOM.ADD_ALL(skin.destination, inputkey_parts.destination)
		end
	end
	-- ノート
	do
		local notes_path = skin_config.get_path("Play/lua/sp/notes.lua")
		local notes_status, notes_parts = pcall(function()
			return dofile(notes_path).load(base, 7)
		end)
		if notes_status and notes_parts then
			CUSTOM.ADD_ALL(skin.image, notes_parts.image)
			skin.note = notes_parts.note
			CUSTOM.ADD_ALL(skin.destination, notes_parts.destination)
		end
	end
	-- カバー
	do
		local cover_path = skin_config.get_path("Play/lua/sp/cover.lua")
		local cover_status, cover_parts = pcall(function()
			return dofile(cover_path).load(base)
		end)
		if cover_status and cover_parts then
			CUSTOM.ADD_ALL(skin.image, cover_parts.image)
			CUSTOM.ADD_ALL(skin.value, cover_parts.value)
			CUSTOM.ADD_ALL(skin.slider, cover_parts.slider)
			CUSTOM.ADD_ALL(skin.hiddenCover, cover_parts.hiddenCover)
			CUSTOM.ADD_ALL(skin.liftCover, cover_parts.liftCover)
			CUSTOM.ADD_ALL(skin.destination, cover_parts.destination)
		end
	end
	-- ターゲット差分、SLOW/FAST
	do
		local assist_path = skin_config.get_path("Play/lua/sp/assist.lua")
		local assist_status, assist_parts = pcall(function()
			return dofile(assist_path).load(base)
		end)
		if assist_status and assist_parts then
			CUSTOM.ADD_ALL(skin.image, assist_parts.image)
			CUSTOM.ADD_ALL(skin.value, assist_parts.value)
			CUSTOM.ADD_ALL(skin.destination, assist_parts.destination)
		end
	end
	-- 爆発
	do
		local bomb7_path = skin_config.get_path("Play/lua/sp/bomb.lua")
		local bomb7_status, bomb7_parts = pcall(function()
			return dofile(bomb7_path).load(base, 7)
		end)
		if bomb7_status and bomb7_parts then
			CUSTOM.ADD_ALL(skin.image, bomb7_parts.image)
			CUSTOM.ADD_ALL(skin.destination, bomb7_parts.destination)
		end
	end
	
	-- 判定カウント、レベル情報部分
	do
		local info2_path = skin_config.get_path("Play/lua/sp/info2.lua")
		local info2_status, info2_parts = pcall(function()
			return dofile(info2_path).load(base)
		end)
		if info2_status and info2_parts then
			CUSTOM.ADD_ALL(skin.image, info2_parts.image)
			CUSTOM.ADD_ALL(skin.value, info2_parts.value)
			CUSTOM.ADD_ALL(skin.destination, info2_parts.destination)
		end
	end
	-- 判定
	do
		local judge_path = skin_config.get_path("Play/lua/sp/judge.lua")
		local judge_status, judge_parts = pcall(function()
			return dofile(judge_path).load(base)
		end)
		if judge_status and judge_parts then
			CUSTOM.ADD_ALL(skin.image, judge_parts.image)
			CUSTOM.ADD_ALL(skin.value, judge_parts.value)
			CUSTOM.ADD_ALL(skin.judge, judge_parts.judge)
			CUSTOM.ADD_ALL(skin.destination, judge_parts.destination)
		end
	end
	-- フルコン演出
	do
		local fullcombo_path = skin_config.get_path("Play/lua/sp/fullcombo.lua")
		local fullcombo_status, fullcombo_parts = pcall(function()
			return dofile(fullcombo_path).load(base)
		end)
		if fullcombo_status and fullcombo_parts then
			CUSTOM.ADD_ALL(skin.image, fullcombo_parts.image)
			CUSTOM.ADD_ALL(skin.destination, fullcombo_parts.destination)
		end
	end
	-- グラフ
	do
		local graph_path = skin_config.get_path("Play/lua/sp/graph.lua")
		local graph_status, graph_parts = pcall(function()
			return dofile(graph_path).load(base)
		end)
		if graph_status and graph_parts then
			CUSTOM.ADD_ALL(skin.image, graph_parts.image)
			CUSTOM.ADD_ALL(skin.value, graph_parts.value)
			CUSTOM.ADD_ALL(skin.graph, graph_parts.graph)
			CUSTOM.ADD_ALL(skin.destination, graph_parts.destination)
		end
	end
	-- 攻撃モーション用
	if PROPERTY.isAttackModeOn() then
		local attack_path = skin_config.get_path("Play/lua/sp/attack.lua")
		local attack_status, attack_parts = pcall(function()
			return dofile(attack_path).load(base.infoPositionX)
		end)
		if attack_status and attack_parts then
			CUSTOM.ADD_ALL(skin.source, attack_parts.source)
			CUSTOM.ADD_ALL(skin.image, attack_parts.image)
			CUSTOM.ADD_ALL(skin.value, attack_parts.value)
			CUSTOM.ADD_ALL(skin.graph, attack_parts.graph)
			CUSTOM.ADD_ALL(skin.destination, attack_parts.destination)
		end
	end
	-- 準備
	do
		local prepare_path = skin_config.get_path("Play/lua/sp/prepare.lua")
		local prepare_status, prepare_parts = pcall(function()
			return dofile(prepare_path).load(base)
		end)
		if prepare_status and prepare_parts then
			CUSTOM.ADD_ALL(skin.image, prepare_parts.image)
			CUSTOM.ADD_ALL(skin.value, prepare_parts.value)
			CUSTOM.ADD_ALL(skin.graph, prepare_parts.graph)
			CUSTOM.ADD_ALL(skin.judgegraph, prepare_parts.judgegraph)
			CUSTOM.ADD_ALL(skin.destination, prepare_parts.destination)
		end
	end
	-- 閉店処理
	do
		local close_path = skin_config.get_path("Play/lua/close.lua")
		local close_status, close_parts = pcall(function()
			return dofile(close_path).load(21)
		end)
		if close_status and close_parts then
			CUSTOM.ADD_ALL(skin.image, close_parts.image)
			CUSTOM.ADD_ALL(skin.destination, close_parts.destination)
		end
	end
	-- 終了時にフェードアウト
	-- timer2 : フェードアウトタイマー fadeoutで定義
	table.insert(skin.destination, {
		id = MAIN.IMAGE.BLACK, timer = MAIN.TIMER.FADEOUT, loop = 500, dst = {
			{time = 0, x = 0, y = 0, w = 1920, h = 1080, a = 0},
			{time = 500, a = 255}
		}
	})
	
	return skin
end

return{
	header = header,
	main = main
}