--[[
	10鍵用メインLua
	@author : KASAKO
	blog: https://www.kasacontent.com/tag/modernchic/
]]
DEBUG = false
-- モジュール読み込み
main_state = require("main_state")
-- requireはディレクトリ区切りを.で表す
PROPERTY = require("Play.lua.require.dp_property").load(true)
COMMONFUNC = require("Play.lua.require.common")
-- ヘッダ読み込み
local header = require("Play.lua.require.header").load(3)
-- 基準点の作成
local function createBasePosition()
	local base = {}
	-- レーン基準
	base.laneLeftPosX = 378
	base.laneRightPosX = 1023
	-- 判定基準
	base.notesPositionY = 227
	return base
end

local function main()
	-- 基本定義読み込み
	MAIN = require("Root.define")
	CUSTOM = require("Root.define2")
	-- テキスト
	local textProperty = require("Play.lua.require.textproperty")
	local skin = {}
	CUSTOM.LOAD_HEADER(skin, header)
	-- 基準点
	local base = createBasePosition()
	
	skin.source =  {
		{id = 1, path = "Play/parts/dp_hw/system.png"},
		{id = 2, path = "Play/parts/dp_hw/lane.png"},
		{id = 3, path = "Play/parts/common/bg/*.png"},
		{id = 4, path = "Play/parts/common/judge/*.png"},
		{id = 5, path = "Play/parts/common/judgeline/*.png"},
		{id = 6, path = "Play/parts/common/notes/*.png"},
		{id = 9, path = "Play/parts/common/glow/*.png"},
		{id = 10, path = "Play/parts/common/progress/*.png"},
		{id = 11, path = "Play/parts/common/bomb/*.png"},
		{id = 13, path = "Play/parts/common/fullcombo/*.png"},
		{id = 14, path = "Play/parts/common/keybeam/*.png"},
		{id = 15, path = "Play/parts/common/key/*.png"},
		{id = 16, path = "Play/parts/common/keyflash/*.png"},
		{id = 17, path = "Play/parts/dp_hw/lanecoverL/*.png"},
		{id = 18, path = "Play/parts/dp_hw/lanecoverR/*.png"},
		{id = 19, path = "Play/parts/dp_hw/lift/*.png"},
--[[
		{id = 19, path = "Play/parts/dp_hw/liftcoverL/*.png"},
		{id = 20, path = "Play/parts/dp_hw/liftcoverR/*.png"},
]]
		{id = 21, path = "Play/parts/common/close/close.png"},
		{id = 22, path = "Play/parts/dp_hw/score.png"},
		{id = 24, path = "Play/parts/common/lamp/*.png"},
		{id = 25, path = "Play/parts/dp_hw/graphbg/*.png"},
		{id = 26, path = "Play/parts/common/mine/#default.png"},
		{id = 28, path = "Play/parts/common/oadx_bomb/*.png"},
		{id = 29, path = "Play/parts/common/gauge/*.png"},
		{id = 30, path = "Play/parts/common/scratch/*.png"},

--		{id = "srcPMchara1P", path = "Play/parts/common/POMYU Chara/*|1P|"},
	}
	
	skin.font = textProperty.font
	skin.text = textProperty.text
	skin.image = {}
	skin.note = {}
	skin.value = {}
	skin.slider = {}
	skin.hiddenCover = {}
	skin.liftCover = {}
	skin.graph = {}
	skin.bga = {id = "bga"}
	skin.judgegraph = {
		-- backTexOff 0：背景黒 1:背景を透過
		{id = "judgegraph", type = 1, backTexOff = 0},
	}
	skin.bpmgraph = {{id = "bpmgraph"}}
	skin.timingvisualizer = {}
	skin.judge = {}
	skin.gauge = {}
	skin.destination = {}
	
	-- 背景
	do
		local background_path = skin_config.get_path("Play/lua/background.lua")
		local background_status, background_parts = pcall(function()
			return dofile(background_path).load(3)
		end)
		if background_status and background_parts then
			CUSTOM.ADD_ALL(skin.image, background_parts.image)
			CUSTOM.ADD_ALL(skin.destination, background_parts.destination)
		end
	end
	-- キーフラッシュ
	do
		local keyflash_path = skin_config.get_path("Play/lua/dp/keyflash.lua")
		local keyflash_status, keyflash_parts = pcall(function()
			return dofile(keyflash_path).load(base, 10)
		end)
		if keyflash_status and keyflash_parts then
			CUSTOM.ADD_ALL(skin.image, keyflash_parts.image)
			CUSTOM.ADD_ALL(skin.destination, keyflash_parts.destination)
		end
	end
	-- インフォ部分
	do
		local info_path = skin_config.get_path("Play/lua/dp/info.lua")
		local info_status, info_parts = pcall(function()
			return dofile(info_path).load()
		end)
		if info_status and info_parts then
			CUSTOM.ADD_ALL(skin.image, info_parts.image)
			CUSTOM.ADD_ALL(skin.value, info_parts.value)
			CUSTOM.ADD_ALL(skin.timingvisualizer, info_parts.timingvisualizer)
			CUSTOM.ADD_ALL(skin.destination, info_parts.destination)
		end
	end
	-- 進捗バー
	do
		local progress_path = skin_config.get_path("Play/lua/dp/progress.lua")
		local progress_status, progress_parts = pcall(function()
			return dofile(progress_path).load()
		end)
		if progress_status and progress_parts then
			CUSTOM.ADD_ALL(skin.image, progress_parts.image)
			CUSTOM.ADD_ALL(skin.slider, progress_parts.slider)
			CUSTOM.ADD_ALL(skin.destination, progress_parts.destination)
		end
	end
	-- レーン部分
	do
		local lane_path = skin_config.get_path("Play/lua/dp/lane.lua")
		local lane_status, lane_parts = pcall(function()
			return dofile(lane_path).load(base)
		end)
		if lane_status and lane_parts then
			CUSTOM.ADD_ALL(skin.image, lane_parts.image)
			CUSTOM.ADD_ALL(skin.destination, lane_parts.destination)
		end
	end
	-- ゲージ
	do
		local gauge_path = skin_config.get_path("Play/lua/dp/gauge.lua")
		local gauge_status, gauge_parts = pcall(function()
			return dofile(gauge_path).load()
		end)
		if gauge_status and gauge_parts then
			CUSTOM.ADD_ALL(skin.image, gauge_parts.image)
			CUSTOM.ADD_ALL(skin.value, gauge_parts.value)
			skin.gauge = gauge_parts.gauge
			CUSTOM.ADD_ALL(skin.destination, gauge_parts.destination)
		end
	end
	-- キー入力
	do
		local inputkey_path = skin_config.get_path("Play/lua/dp/inputkey.lua")
		local inputkey_status, inputkey_parts = pcall(function()
			return dofile(inputkey_path).load(base, 10)
		end)
		if inputkey_status and inputkey_parts then
			CUSTOM.ADD_ALL(skin.image, inputkey_parts.image)
			CUSTOM.ADD_ALL(skin.destination, inputkey_parts.destination)
		end
	end
	-- ノート
	do
		local notes_path = skin_config.get_path("Play/lua/dp/notes.lua")
		local notes_status, notes_parts = pcall(function()
			return dofile(notes_path).load(base, 10)
		end)
		if notes_status and notes_parts then
			CUSTOM.ADD_ALL(skin.image, notes_parts.image)
			skin.note = notes_parts.note
			CUSTOM.ADD_ALL(skin.destination, notes_parts.destination)
		end
	end
	-- カバー
	do
		local cover_path = skin_config.get_path("Play/lua/dp/cover.lua")
		local cover_status, cover_parts = pcall(function()
			return dofile(cover_path).load(base)
		end)
		if cover_status and cover_parts then
			CUSTOM.ADD_ALL(skin.image, cover_parts.image)
			CUSTOM.ADD_ALL(skin.value, cover_parts.value)
			CUSTOM.ADD_ALL(skin.slider, cover_parts.slider)
			CUSTOM.ADD_ALL(skin.hiddenCover, cover_parts.hiddenCover)
			CUSTOM.ADD_ALL(skin.liftCover, cover_parts.liftCover)
			CUSTOM.ADD_ALL(skin.destination, cover_parts.destination)
		end
	end
	-- 10鍵用カバー
	if PROPERTY.is10keyLanecoverOn() then
		table.insert(skin.image, {id = "10keysFrame", src = 1, x = 1500, y = 340, w = 114, h = 900})
		table.insert(skin.destination,{
			id = "10keysFrame", loop = 1500, dst = {
				{time = 0, x = base.laneLeftPosX + 405, y = 1080, w = 114, h = 900, acc = MAIN.ACC.DECELERATE, a = 240, angle = 180},
				{time = 1000},
				{time = 1500, y = base.notesPositionY - 47}
			}
		})
		table.insert(skin.destination,{
			id = "10keysFrame", loop = 1500, dst = {
				{time = 0, x = base.laneRightPosX, y = 1080, w = 114, h = 900, acc = MAIN.ACC.DECELERATE, a = 240, angle = 0},
				{time = 1000},
				{time = 1500, y = base.notesPositionY - 47}
			}
		})
	end
	-- 判定
	do
		local judge_path = skin_config.get_path("Play/lua/dp/judge.lua")
		local judge_status, judge_parts = pcall(function()
			return dofile(judge_path).load(base)
		end)
		if judge_status and judge_parts then
			CUSTOM.ADD_ALL(skin.image, judge_parts.image)
			CUSTOM.ADD_ALL(skin.value, judge_parts.value)
			CUSTOM.ADD_ALL(skin.judge, judge_parts.judge)
			CUSTOM.ADD_ALL(skin.destination, judge_parts.destination)
		end
	end
	-- 準備
	do
		local prepare_path = skin_config.get_path("Play/lua/dp/prepare.lua")
		local prepare_status, prepare_parts = pcall(function()
			return dofile(prepare_path).load(base)
		end)
		if prepare_status and prepare_parts then
			CUSTOM.ADD_ALL(skin.image, prepare_parts.image)
			CUSTOM.ADD_ALL(skin.value, prepare_parts.value)
			CUSTOM.ADD_ALL(skin.graph, prepare_parts.graph)
			CUSTOM.ADD_ALL(skin.judgegraph, prepare_parts.judgegraph)
			CUSTOM.ADD_ALL(skin.destination, prepare_parts.destination)
		end
	end
	-- グラフ
	do
		local graph_path = skin_config.get_path("Play/lua/dp/graph.lua")
		local graph_status, graph_parts = pcall(function()
			return dofile(graph_path).load()
		end)
		if graph_status and graph_parts then
			CUSTOM.ADD_ALL(skin.image, graph_parts.image)
			CUSTOM.ADD_ALL(skin.value, graph_parts.value)
			CUSTOM.ADD_ALL(skin.graph, graph_parts.graph)
			CUSTOM.ADD_ALL(skin.destination, graph_parts.destination)
		end
	end
	-- ターゲット差分、SLOW/FAST
	do
		local assist_path = skin_config.get_path("Play/lua/dp/assist.lua")
		local assist_status, assist_parts = pcall(function()
			return dofile(assist_path).load(base)
		end)
		if assist_status and assist_parts then
			CUSTOM.ADD_ALL(skin.image, assist_parts.image)
			CUSTOM.ADD_ALL(skin.value, assist_parts.value)
			CUSTOM.ADD_ALL(skin.destination, assist_parts.destination)
		end
	end
	-- 爆発
	do
		local bomb7_path = skin_config.get_path("Play/lua/dp/bomb.lua")
		local bomb7_status, bomb7_parts = pcall(function()
			return dofile(bomb7_path).load(base, 10)
		end)
		if bomb7_status and bomb7_parts then
			CUSTOM.ADD_ALL(skin.image, bomb7_parts.image)
			CUSTOM.ADD_ALL(skin.destination, bomb7_parts.destination)
		end
	end
	-- フルコン演出
	do
		local fullcombo_path = skin_config.get_path("Play/lua/dp/fullcombo.lua")
		local fullcombo_status, fullcombo_parts = pcall(function()
			return dofile(fullcombo_path).load(base)
		end)
		if fullcombo_status and fullcombo_parts then
			CUSTOM.ADD_ALL(skin.image, fullcombo_parts.image)
			CUSTOM.ADD_ALL(skin.destination, fullcombo_parts.destination)
		end
	end
	-- 閉店処理
	do
		local close_path = skin_config.get_path("Play/lua/close.lua")
		local close_status, close_parts = pcall(function()
			return dofile(close_path).load(21)
		end)
		if close_status and close_parts then
			CUSTOM.ADD_ALL(skin.image, close_parts.image)
			CUSTOM.ADD_ALL(skin.destination, close_parts.destination)
		end
	end
	-- 終了時にフェードアウト
	-- timer2 : フェードアウトタイマー fadeoutで定義
	table.insert(skin.destination, {
		id = MAIN.IMAGE.BLACK, timer = MAIN.TIMER.FADEOUT, loop = 500, dst = {
			{time = 0, x = 0, y = 0, w = 1920, h = 1080, a = 0},
			{time = 500, a = 255}
		}
	})
	
	return skin
end

return{
	header = header,
	main = main
}