--[[
	曲決定画面
	@author : KASAKO
	blog: https://www.kasacontent.com/tag/modernchic/
]]
DEBUG = false
-- モジュール読み込み
main_state = require("main_state")
PROPERTY = require("Decide.lua.require.property")
local header = require("Decide.lua.require.header")

local function rand(min, max)
	return math.random(min, max)
end

local function diffRGB()
	if main_state.option(151) then
		return {6, 255, 0}
	elseif main_state.option(152) then
		return {18, 210, 215}
	elseif main_state.option(153) then
		return {255, 192, 0}
	elseif main_state.option(154) then
		return {255, 0, 0}
	elseif main_state.option(155) then
		return {148, 44, 150}
	elseif main_state.option(150) then
		return {195, 195, 195}
	end
end

local function main()
	-- 基本定義読み込み
	MAIN = require("Root.define")
	CUSTOM = require("Root.define2")
	-- テキスト関連
	local textProperty = require("Decide.lua.require.textproperty")
	local skin = {}
	CUSTOM.LOAD_HEADER(skin, header)
	
	skin.source =  {
		{id = 1, path = "Decide/bg/image/*.png"},
		{id = 2, path = "Decide/bg/movie/*.mp4"},
		{id = 3, path = "Decide/parts/parts.png"},
		{id = 4, path = "Decide/parts/parts2.png"},
	}
	
	-- フォント
	skin.font = textProperty.font
	skin.text = textProperty.text
	
	--背景選択
	local bg_type
	if PROPERTY.isBgImage() then
		bg_type = 1
	else
		bg_type = 2
	end
	skin.image = {
		--背景
		{id = "bg", src = bg_type, x = 0, y = 0, w = 1920, h = 1080},
		{id = "beginner", src = 3, x = 0, y = 558, w = 240, h = 45},
		{id = "normal", src = 3, x = 0, y = 603, w = 240, h = 45},
		{id = "hyper", src = 3, x = 0, y = 648, w = 240, h = 45},
		{id = "another", src = 3, x = 0, y = 693, w = 240, h = 45},
		{id = "insane", src = 3, x = 0, y = 738, w = 240, h = 45},
		{id = "unknown", src = 3, x = 0, y = 783, w = 240, h = 45},
		{id = "getready", src = 4, x = 0, y = 0, w = 730, h = 50},
		{id = "lockon-lu", src = 4, x = 0, y = 50, w = 50, h = 50},
		{id = "lockon-ru", src = 4, x = 60, y = 50, w = 50, h = 50},
		{id = "lockon-ld", src = 4, x = 120, y = 50, w = 50, h = 50},
		{id = "lockon-rd", src = 4, x = 180, y = 50, w = 50, h = 50},
	}
	skin.value = {
		--選曲レベル
		{id = "levelBeginner", src = 3, x = 0, y = 0, w = 710, h = 93, divx = 10, digit = 2, align = MAIN.N_ALIGN.CENTER, ref = MAIN.NUM.PLAYLEVEL},
		{id = "levelNormal", src = 3, x = 0, y = 93, w = 710, h = 93, divx = 10, digit = 2, align = MAIN.N_ALIGN.CENTER, ref = MAIN.NUM.PLAYLEVEL},
		{id = "levelHyper", src = 3, x = 0, y = 186, w = 710, h = 93, divx = 10, digit = 2, align = MAIN.N_ALIGN.CENTER, ref = MAIN.NUM.PLAYLEVEL},
		{id = "levelAnother", src = 3, x = 0, y = 279, w = 710, h = 93, divx = 10, digit = 2, align = MAIN.N_ALIGN.CENTER, ref = MAIN.NUM.PLAYLEVEL},
		{id = "levelInsane", src = 3, x = 0, y = 372, w = 710, h = 93, divx = 10, digit = 2, align = MAIN.N_ALIGN.CENTER, ref = MAIN.NUM.PLAYLEVEL},
		{id = "levelUnknown", src = 3, x = 0, y = 465, w = 710, h = 93, divx = 10, digit = 2, align = MAIN.N_ALIGN.CENTER,ref = MAIN.NUM.PLAYLEVEL},
	}
	skin.judgegraph = {{id = "notes-graph", noGap = 0, type = 0}}
	skin.bpmgraph = {{id = "bpmgraph"}}
	
	local tablenamePosX = 960
	local tablenamePosY = 900
	local genrePosX = 960
	local genrePosY = 620
	local titlePosX = 960
	local titlePosY = 490
	local artistPosX = 960
	local artistPosY = 420
	local categoryPosX = 840
	local categoryPosY = 710
	local levelPosX = 890
	local levelPosY = 300
	
	skin.destination = {}
	
	-- 背景配置
	table.insert(skin.destination,{
		id = "bg", dst = {
			{x = 0, y = 0, w = 1920, h = 1080}
		}
	})
	-- ステージファイル
	if PROPERTY.isStagefileOn() then
		table.insert(skin.destination,	{
			id = MAIN.IMAGE.STAGEFILE, loop = 1500, dst = {
				{time = 500, x = 910, y = 490, w = 1, h = 1},
				{time = 1500, x = 640, y = 300, w = 640, h = 480},
			}
		})
	end
	-- 表示用背景
	table.insert(skin.destination,	{
		id = MAIN.IMAGE.BLACK, loop = 500, dst = {
			{time = 0, x = 960, y = 585, w = 1, h = 1, a = 150},
			{time = 500, x = 0, y = 240, w = 1920, h = 600}
		}
	})
	do
		local num1 = rand(0, 255)
		local num2 = rand(0, 255)
		local num3 = rand(0, 255)
		local preWH = 500
		local startTime = 0
		local loopTime = 1000
		local alphaNum = 50
		local accNum = 1
		local RGB = diffRGB()
		-- アニメーション
		for i = 1, 7, 1 do
			table.insert(skin.destination, {
				id = "lockon-lu", loop = loopTime, dst = {
					{time = startTime, x = 0, y = 1080 - preWH, w = preWH, h = preWH, acc = accNum, a = alphaNum, r = num1, g = num2, b = num3},
					{time = loopTime, x = 627, y = 743, w = 50, h = 50, a = 255, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			table.insert(skin.destination, {
				id = "lockon-ru", loop = loopTime, dst = {
					{time = startTime, x = 1920 - preWH, y = 1080 - preWH, w = preWH, h = preWH, acc = accNum, a = alphaNum, r = num1, g = num2, b = num3},
					{time = loopTime, x = 1243, y = 743, w = 50, h = 50, a = 255, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			table.insert(skin.destination, {
				id = "lockon-ld", loop = loopTime, dst = {
					{time = startTime, x = 0, y = 0, w = preWH, h = preWH, acc = accNum, a = alphaNum, r = num1, g = num2, b = num3},
					{time = loopTime, x = 627, y = 288, w = 50, h = 50, a = 255, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			table.insert(skin.destination, {
				id = "lockon-rd", loop = loopTime, dst = {
					{time = startTime, x = 1920 - preWH, y = 0, w = preWH, h = preWH, acc = accNum, a = alphaNum, r = num1, g = num2, b = num3},
					{time = loopTime, x = 1243, y = 288, w = 50, h = 50, a = 255, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			startTime = startTime + 200
			loopTime = loopTime + 100
		end
	end
		
	do
		local option = {MAIN.OP.DIFFICULTY1, MAIN.OP.DIFFICULTY2, MAIN.OP.DIFFICULTY3, MAIN.OP.DIFFICULTY4, MAIN.OP.DIFFICULTY5, MAIN.OP.DIFFICULTY0}
		local cat = {"beginner", "normal", "hyper", "another", "insane", "unknown"}
		local lev = {"levelBeginner", "levelNormal", "levelHyper", "levelAnother", "levelInsane", "levelUnknown"}
		local RGB = diffRGB()
		for i = 1, 6, 1 do
			-- テーブル名
			table.insert(skin.destination, {
				id = "tablename&tablelevel", op = {option[i]}, dst = {
					{x = tablenamePosX, y = tablenamePosY, w = 1720, h = 35, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			-- ジャンル名
			table.insert(skin.destination, {
				id = "genre", op = {option[i]}, dst = {
					{x = genrePosX, y = genrePosY, w = 1720, h = 40, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			-- タイトル
			table.insert(skin.destination, {
				id = "title", op = {option[i]}, dst = {
					{x = titlePosX, y = titlePosY, w = 1720, h = 90, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			-- アーティスト
			table.insert(skin.destination, {
				id = "artist", op = {option[i]}, dst = {
					{x = artistPosX, y = artistPosY, w = 1720, h = 40, r = RGB[1], g = RGB[2], b = RGB[3]}
				}
			})
			-- カテゴリ
			table.insert(skin.destination, {
				id = cat[i], op = {option[i]}, dst = {
					{x = categoryPosX, y = categoryPosY, w = 240, h = 45}
				}
			})
			-- レベル
			table.insert(skin.destination, {
				id = lev[i], op = {option[i]}, dst = {
					{x = levelPosX, y = levelPosY, w = 71, h = 93}
				}
			})
		end
	end

	-- ノート分布グラフ
	if PROPERTY.isNotesGraphOn() then
		local graphWidth = 1000
		local graphHeight = 150
		table.insert(skin.destination, {
			id = "notes-graph", dst = {
				{x = (1920 / 2) - (graphWidth / 2), y = 50, w = graphWidth, h = graphHeight},
			}
		})
		table.insert(skin.destination, {
			id = "bpmgraph", dst = {
				{x = (1920 / 2) - (graphWidth / 2), y = 50, w = graphWidth, h = graphHeight},
			}
		})
	end
	
	-- 黒背景でフェードアウト
	table.insert(skin.destination, {
		id = MAIN.IMAGE.BLACK, loop = 1000, timer = MAIN.TIMER.FADEOUT, dst = {
			{time = 0, x = 0, y = 540, w = 1920, h = 0},
			{time = 500},
			{time = 1000, y = 0, h = 1080},
		}
	})
	table.insert(skin.destination, {
		id = "getready", loop = 1000, timer = MAIN.TIMER.FADEOUT, dst = {
			{time = 500, x = 598, y = 514, w = 730, h = 50},
			{time = 600, a = 0},
			{time = 700, a = 255},
			{time = 800, a = 0},
			{time = 850, a = 255},
			{time = 900, a = 0},
			{time = 950, a = 255},
		}
	})
	return skin
end

return{
	header = header,
	main = main
}