--[[
	新バージョンがあるかどうかをチェックする
	@author : KASAKO
]]

local http = require("Select.lua.require.http")

local function load(version)
	local parts = {}

	-- スキンバージョンチェック
	local isNewVer = false
	
	if PROPERTY.isCheckNewVersionOn() then
		isNewVer = http.skinVersionCheck(version)
	end

	parts.image = {
		-- 新バージョン宣伝
		{id = "newVerionUpdate", src = 5, x = 1400, y = 2250, w = 267, h = 40, divy = 2, cycle = 100},
		{id = "newVerionNone", src = 5, x = 1400, y = 2290, w = 267, h = 20},
	}

	-- カスタムタイマー
	local exsistNewVersion = CUSTOM.GET_CUSTOMTIMER_ID()
	local versionCheckComplate = CUSTOM.GET_CUSTOMTIMER_ID()
	parts.customTimers = {
		{id = exsistNewVersion, timer = timer_util.timer_observe_boolean(function()
			if isNewVer == true then
				return true
			else
				return false
			end
		end)},
		{id = versionCheckComplate, timer = timer_util.timer_observe_boolean(function()
			if isNewVer ~= true then
				return true
			else
				return false
			end
		end)},
	}
	
	parts.destination = {}

	-- 新バージョン宣伝
	table.insert(parts.destination, {
		id = "newVerionUpdate", loop = 0, timer = exsistNewVersion, dst = {
			{time = 0, x = 180, y = 1050, w = 267, h = 20}
		}
	})
	table.insert(parts.destination, {
		id = "newVerionNone", loop = 0, timer = versionCheckComplate, dst = {
			{time = 0, x = 180, y = 1050, w = 267, h = 20}
		}
	})

	return parts
end

return {
	load = load
}