--[[
    参考
    https://libgdx.badlogicgames.com/ci/nightlies/docs/api/com/badlogic/gdx/Gdx.html
    https://libgdx.badlogicgames.com/ci/nightlies/docs/api/com/badlogic/gdx/Audio.html
]]

local luajava = require("luajava")
local gdx = luajava.bindClass("com.badlogic.gdx.Gdx")
local audio = nil

local Sound = {

    -- SE一覧
    effect = {
        favorite = skin_config.get_path("Result/sounds/favorite.ogg"),
        change = skin_config.get_path("Result/sounds/change.ogg")
    },

    init = function()
        pcall(function() audio = gdx.app:getApplicationListener():getAudioProcessor() end)
    end,

    -- Plays the sound. vol（音量は最大：1.0）
    play = function(path, vol)
        if DEBUG then
            print("音声ファイル：" ..path .."、音量：" ..vol)
        end
        pcall(function()
            audio:play(path, vol)
        end)
    end,

    -- Releases all the resources
    dispose = function(path)
        pcall(function()
            if DEBUG then
                print("DISPOSE COMP")
            end
            audio:dispose(path)
        end)
    end
}

return Sound