--[[
	キー画像と対応するキーフラッシュを配置
	@author : KASAKO
--]]
local function createNumber()
	return math.random(50, 155)
end

local function load(base, num)
	local parts = {}
	
	local keyflashNormalWidth = 67
	local keyflashNormalHeight = 73
	local keyflashScratchWidth = 92
	local keyflashScratchHeight = 92

	local whitePosY = 137
	local blackPosY = 147

	local keyFramePosX
	local scratchFramePosX
	local scratchImagePosX

	if PROPERTY.isLeftScratch() then
		keyFramePosX = 111
		scratchFramePosX = 0
		scratchImagePosX = 9
	elseif PROPERTY.isRightScratch() then
		keyFramePosX = 0
		scratchFramePosX = 408
		scratchImagePosX = 417
	end

	local flashTimer
	if num == 5 then
		flashTimer = {
			MAIN.TIMER.KEYON_1P_KEY1,
			MAIN.TIMER.KEYON_1P_KEY2,
			MAIN.TIMER.KEYON_1P_KEY3,
			MAIN.TIMER.KEYON_1P_KEY4,
			MAIN.TIMER.KEYON_1P_KEY5
		}
	elseif num == 7 then
		flashTimer = {
			MAIN.TIMER.KEYON_1P_KEY1,
			MAIN.TIMER.KEYON_1P_KEY2,
			MAIN.TIMER.KEYON_1P_KEY3,
			MAIN.TIMER.KEYON_1P_KEY4,
			MAIN.TIMER.KEYON_1P_KEY5,
			MAIN.TIMER.KEYON_1P_KEY6,
			MAIN.TIMER.KEYON_1P_KEY7
		}
	end
	
	parts.image = {
		-- キー部分
		{id = "keyBg", src = 15, x = 0, y = 0, w = 408, h = 114},
		{id = "keyFrame", src = 15, x = 0, y = 114, w = 408, h = 114},
		-- 皿部分
		{id = "scratchBg", src = 15, x = 408, y = 0, w = 111, h = 114},
		{id = "scratchFrame", src = 15, x = 408, y = 114, w = 111, h = 114},
		{id = "scratchFrame2", src = 15, x = 408, y = 228, w = 111, h = 114},
		-- カバー部分
		{id = "keyCoverTop", src = 15, x = 0, y = 228, w = 408, h = 57},
		{id = "keyCoverBottom", src = 15, x = 0, y = 285, w = 408, h = 57},
		-- キーフラッシュ
		{id = "keyflash_n", src = 16, x = 0, y = 0, w = keyflashNormalWidth, h = keyflashNormalHeight},
		-- スクラッチ
		{id = "scratchImage", src = 30, x = 0, y = 0, w = keyflashScratchWidth, h = keyflashScratchHeight},
	}
	
	parts.destination = {}
	
	do
		local flashPosX = base.keyflashPosX
		local flashPosY = {whitePosY, blackPosY, whitePosY, blackPosY, whitePosY, blackPosY, whitePosY}
		local red = createNumber()
		local green = createNumber()
		local blue = createNumber()
		
		-- キー部分
		table.insert(parts.destination,	{
			id = "keyBg", dst = {
				{x = base.playsidePositionX + keyFramePosX, y = 110, w = 408, h = 114},
			}
		})
		table.insert(parts.destination,	{
			id = "keyFrame", dst = {
				{x = base.playsidePositionX + keyFramePosX, y = 110, w = 408, h = 114},
			}
		})
		-- 皿部分
		table.insert(parts.destination,	{
			id = "scratchBg", dst = {
				{x = base.playsidePositionX + scratchFramePosX, y = 110, w = 111, h = 114},
			}
		})
		table.insert(parts.destination,	{
			id = "scratchFrame", dst = {
				{x = base.playsidePositionX + scratchFramePosX, y = 110, w = 111, h = 114},
			}
		})
		table.insert(parts.destination,	{
			id = "scratchFrame2", loop = 1500, dst = {
				{time = 1000, x = base.playsidePositionX + scratchFramePosX, y = 110, w = 111, h = 114, r = red, g = green, b = blue, a = 0},
				{time = 1500, a = 255}
			}
		})
		-- ロード完了後に光るように
		table.insert(parts.destination,	{
			id = "scratchFrame2", op = {MAIN.OP.LOADED, MAIN.OP.AUTOPLAYOFF}, timer = MAIN.TIMER.KEYON_1P_SCRATCH, loop = -1, dst = {
				{time = 0, x = base.playsidePositionX + scratchFramePosX, y = 110, w = 111, h = 114, r = red + 100, g = green + 100, b = blue + 100},
				{time = 50, a = 0}
			}
		})
		-- オート
		table.insert(parts.destination,	{
			id = "scratchFrame2", op = {MAIN.OP.LOADED, MAIN.OP.AUTOPLAYON}, timer = MAIN.TIMER.KEYON_1P_SCRATCH, dst = {
				{time = 0, x = base.playsidePositionX + scratchFramePosX, y = 110, w = 111, h = 114, r = red + 100, g = green + 100, b = blue + 100},
				{time = 50, a = 0}
			}
		})
		-- キーフラッシュ配置（鍵盤）
		for i = 1, num, 1 do
			table.insert(parts.destination,	{
				id = "keyflash_n", timer = flashTimer[i], blend = MAIN.BLEND.ADDITION, dst = {
					{x = base.playsidePositionX + flashPosX[i], y = flashPosY[i], w = keyflashNormalWidth, h = keyflashNormalHeight},
				}
			})
		end
		-- 皿
		table.insert(parts.destination,	{
			id = "scratchImage", filter = MAIN.FILTER.ON, offset = MAIN.OFFSET.SCRATCHANGLE_1P, dst = {
				{x = base.playsidePositionX + scratchImagePosX, y = 121, w = keyflashScratchWidth, h = keyflashScratchHeight},
			}
		})
		-- キーカバー
		table.insert(parts.destination, {
			id = "keyCoverTop", loop = -1, stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, dst = {
				{time = 0, x = base.playsidePositionX + keyFramePosX, y = 167, w = 408, h = 57, acc = MAIN.ACC.DECELERATE},
				{time = 1000},
				{time = 1300, y = 167 + 57, h = 0}
			}
		})
		table.insert(parts.destination, {
			id = "keyCoverBottom", loop = -1, stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, dst = {
				{time = 0, x = base.playsidePositionX + keyFramePosX, y = 110, w = 408, h = 57, acc = MAIN.ACC.DECELERATE},
				{time = 1000},
				{time = 1300, h = 0}
			}
		})
	end
	return parts
end

return {
	load = load
}