--[[
	プレイ情報部分
	@author : KASAKO
--]]

local function createTimingVisualizer(contents)
	local width = 300
	local judgeWidthMillis = nil
	local lineWidth = 1
	local lineColor = "00FF00FF"
	local centerColor = "FFFFFFFF"
	local PGColor = "000088FF"
	local GRColor = "008800FF"
	local GDColor = "888800FF"
	local BDColor = "880000FF"
	local PRColor = "000000FF"
	local transparent = 0
	local drawDecay = 1
	-- 倍率
	if PROPERTY.isTiminggraphMagnificationLow() then
		-- +-225ms
		judgeWidthMillis = 225
	elseif PROPERTY.isTiminggraphMagnificationNormal() then
		-- +-150ms
		judgeWidthMillis = 150
	elseif PROPERTY.isTiminggraphMagnificationHigh() then
		-- +-75ms
		judgeWidthMillis = 75
	end
	-- カラーパターン
	if PROPERTY.isTiminggraphColorRed() then
		lineColor = "E286A7FF"
		PGColor = "440000FF"
		GRColor = "990000FF"
		GDColor = "440000FF"
		BDColor = "990000FF"
		PRColor = "000000FF"
	elseif PROPERTY.isTiminggraphColorGreen() then
		lineColor = "86E088FF"
		PGColor = "004400FF"
		GRColor = "008800FF"
		GDColor = "004400FF"
		BDColor = "008800FF"
		PRColor = "000000FF"
	elseif PROPERTY.isTiminggraphColorBlue() then
		lineColor = "89DDDCFF"
		PGColor = "222244FF"
		GRColor = "222299FF"
		GDColor = "222244FF"
		BDColor = "222299FF"
		PRColor = "000000FF"
	end

	table.insert(contents, {
		id = "timing",
		width = width,
		judgeWidthMillis = judgeWidthMillis,
		lineWidth = lineWidth,
		lineColor = lineColor,
		centerColor = centerColor,
		PGColor = PGColor,
		GRColor = GRColor,
		GDColor = GDColor,
		BDColor = BDColor,
		PRColor = PRColor,
		transparent = transparent,
		drawDecay = drawDecay
	})
end

local function load(base)
	local parts = {}
	
	parts.image = {
		-- 1P用タイトルフレーム
		{id = "infoTitleFrame1p", src = 2, x = 0, y = 0, w = 1350, h = 46},
		-- 2P用タイトルフレーム
		{id = "infoTitleFrame2p", src = 2, x = 0, y = 58, w = 1350, h = 46},
		-- BGA,score,bpm,comboフレーム
		{id = "infoFrame", src = 2, x = 0, y = 110, w = 1350, h = 811},
		-- ノート分布グラフフレーム
		{id = "infoNotesDistributionFrame", src = 2, x = 808, y = 926, w = 519, h = 142},
		-- 判定グラフフレーム
		{id = "infoJudgegraphFrame", src = 2, x = 808, y = 1072, w = 519, h = 54},
		-- 数値くるくる
		{id = "roulette_number_1", src = 1, x = 0, y = 950, w = 280, h = 36, divx = 10, cycle = 100},
		{id = "roulette_number_2", src = 1, x = 0, y = 950, w = 280, h = 36, divx = 10, cycle = 200},
		{id = "roulette_number_3", src = 1, x = 0, y = 950, w = 280, h = 36, divx = 10, cycle = 400},
		-- SoundOnly
		{id = "soundonly", src = 1, x = 570, y = 270, w = 600, h = 350},
		-- エフェクターフレーム
		{id = "effecter_frame", src = 1, x = 810, y = 1050, w = 308, h = 37},
		-- エフェクター
		{id = "effecter_nonactive", src = 1, x = 600, y = 0, w = 227, h = 28},
		{id = "effecter_active", src = 1, x = 830, y = 0, w = 227, h = 28},
		--LNタイプ
		{id = "btn-lnmode_nonactive", src = 1, x = 600, y = 28, w = 227, h = 84, divy = 3, len = 3, ref = MAIN.BUTTON.LNMODE},
		{id = "btn-lnmode_active", src = 1, x = 830, y = 28, w = 227, h = 84, divy = 3, len = 3, ref = MAIN.BUTTON.LNMODE},
		-- ノート分布カバー
		{id = "notesCover", src = 2, x = 780, y = 1130, w = 519, h = 140},
		-- タイミンググラフカバー
		{id = "timingCover", src = 2, x = 780, y = 1280, w = 519, h = 54},
		-- 修飾
		{id = "lamp_rhythm", src = 24, x = 0, y = 0, w = 152, h = 108},
		{id = "lamp_gaugeinclease", src = 24, x = 0, y = 0, w = 152, h = 216, divy = 2, cycle = 50, timer = MAIN.TIMER.GAUGE_INCLEASE_1P},
		{id = "lamp_maxgauge", src = 24, x = 0, y = 0, w = 152, h = 216, divy = 2, cycle = 50, timer = MAIN.TIMER.GAUGE_MAX_1P},
		-- タイミンググラフ・棒グラフタイプ
		{id = "tgBFrame", src = 1, x = 600, y = 630, w = 472, h = 30},
		{id = "tgBFrame2", src = 1, x = 600, y = 660, w = 472, h = 30},
		-- タイミング調節ボタン
		{id = "timingAdjustBtn", src = 1, x = 2, y = 0, w = 1, h = 1, act = MAIN.BUTTON.JUDGE_TIMING}
	}
	
	parts.value = {
		-- 現在のスコア
		{id = "nowscore", src = 1, x = 0, y = 950, w = 308, h = 36, divx = 11, divy = 1, digit = 6, ref = MAIN.NUM.POINT, zeropadding = 1},
		-- 現在の最大コンボ数
		{id = "maxcombo", src = 1, x = 0, y = 950, w = 308, h = 36, divx = 11, divy = 1, digit = 5, ref = MAIN.NUM.MAXCOMBO2},
		-- 現在のEXスコア
		{id = "nowexscore", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 11, divy = 1, digit = 4, ref = MAIN.NUM.SCORE2, zeropadding = 1},
		
		-- 最大BPM
		{id = "maxbpm", src = 1, x = 0, y = 950, w = 280, h = 36, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM, align = MAIN.N_ALIGN.CENTER},
		-- 現在のBPM
		{id = "nowbpm", src = 1, x = 0, y = 950, w = 280, h = 36, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.NOWBPM, align = MAIN.N_ALIGN.CENTER},
		-- 最小BPM
		{id = "minbpm", src = 1, x = 0, y = 950, w = 280, h = 36, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM, align = MAIN.N_ALIGN.CENTER},
		
		-- 残り時間
		{id = "min_time", src = 1, x = 1400, y = 81, w = 297, h = 20, divx = 11, divy = 1, digit = 2, ref = MAIN.NUM.TIMELEFT_MINUTE},
		{id = "sec_time", src = 1, x = 1400, y = 81, w = 297, h = 20, divx = 11, divy = 1, digit = 2, ref = MAIN.NUM.TIMELEFT_SECOND},

		-- judgetimingnumber
		{id = "judgeTimingNum", src = 1, x = 1400, y = 121, w = 324, h = 40, divx = 12, divy = 2, digit = 4, ref = MAIN.NUM.JUDGETIMING, zeropadding = MAIN.N_ZEROPADDING.OFF, align = MAIN.N_ALIGN.CENTER},
	}

	parts.graph = {
		-- FAST
		{id = "gra_fastRate", src = 1, x = 600, y = 690, w = 468, h = 26, angle = 0, value = function()
			return CUSTOM.GRAPH.FastRate()
		end},
		-- SLOW
		{id = "gra_slowRate", src = 1, x = 600, y = 716, w = 468, h = 26, angle = 0, value = function()
			return CUSTOM.GRAPH.SlowRate()
		end},
	}

	parts.timingvisualizer = {}
	createTimingVisualizer(parts.timingvisualizer)
	parts.destination = {}
	
	do
		-- 難易度によって色を変えてみる
		local RGB = COMMONFUNC.setRGB()
		
		-- タイトル、アーティスト、ジャンルポジション
		local topInfoPosX
		-- 残り分数ポジション
		local minPosX
		-- 残り秒数ポジション
		local secPosX
		
		if PROPERTY.isLeftPosition() then
			topInfoPosX = 775
			minPosX = 100
			secPosX = 170
			-- 2P用タイトルフレーム
			table.insert(parts.destination,{
				id = "infoTitleFrame1p", dst = {
					{x = base.infoPositionX, y = 1026, w = 1350, h = 46},
				}
			})
		elseif PROPERTY.isRightPosition() then
			topInfoPosX = 575
			minPosX = 1200
			secPosX = 1270
			-- 2P用タイトルフレーム
			table.insert(parts.destination,{
				id = "infoTitleFrame2p", dst = {
					{x = base.infoPositionX, y = 1026, w = 1350, h = 46},
				}
			})
		end
		-- タイトル、アーティスト、ジャンルの順にループ
		-- 中央寄せ（align:1）なのでx値は中心位置
		if main_state.text(MAIN.STRING.TABLE_FULL) == "" then
			table.insert(parts.destination,	{
				id = "title", loop = 0, dst = {
					{time = 0, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 2000, a = 255},
					{time = 7000},
					{time = 9000, a = 0},
					{time = 27000}
				}
			})
			table.insert(parts.destination,	{
				id = "artist", loop = 0, dst = {
					{time = 9000, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 11000, a = 255},
					{time = 16000},
					{time = 18000, a = 0},
					{time = 27000}
				}
			})
			table.insert(parts.destination,	{
				id = "genre", loop = 0, dst = {
					{time = 18000, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 20000, a = 255},
					{time = 25000},
					{time = 27000, a = 0},
				}
			})
		else
			table.insert(parts.destination,	{
				id = "title", loop = 0, dst = {
					{time = 0, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 2000, a = 255},
					{time = 7000},
					{time = 9000, a = 0},
					{time = 36000}
				}
			})
			table.insert(parts.destination,	{
				id = "artist", loop = 0, dst = {
					{time = 9000, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 11000, a = 255},
					{time = 16000},
					{time = 18000, a = 0},
					{time = 36000}
				}
			})
			table.insert(parts.destination,	{
				id = "genre", loop = 0, dst = {
					{time = 18000, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 20000, a = 255},
					{time = 25000},
					{time = 27000, a = 0},
					{time = 36000},
				}
			})
			table.insert(parts.destination,	{
				id = "difftbl", loop = 0, dst = {
					{time = 27000, x = base.infoPositionX + topInfoPosX, y = 1033, w = 1040, h = 25, a = 0, r = RGB[1], g = RGB[2], b = RGB[3]},
					{time = 29000, a = 255},
					{time = 34000},
					{time = 36000, a = 0},
				}
			})
		end
		-- 残り時間
		table.insert(parts.destination,	{
			id = "min_time", draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) >= 60
			end,
			dst = {
				{x = base.infoPositionX + minPosX, y = 1031, w = 27, h = 20},
			}
		})
		table.insert(parts.destination,	{
			id = "sec_time", draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) >= 60
			end,
			dst = {
				{x = base.infoPositionX + secPosX, y = 1031, w = 27, h = 20},
			}
		})
		-- 残り時間が60秒を切ると色を変える
		table.insert(parts.destination,	{
			id = "min_time", draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) < 60
			end,
			dst = {
				{x = base.infoPositionX + minPosX, y = 1031, w = 27, h = 20, r = 253, g = 126, b = 0},
			}
		})
		table.insert(parts.destination,	{
			id = "sec_time", draw = function()
				return (main_state.number(MAIN.NUM.TIMELEFT_MINUTE) * 60) + main_state.number(MAIN.NUM.TIMELEFT_SECOND) < 60
			end,
			dst = {
				{x = base.infoPositionX + secPosX, y = 1031, w = 27, h = 20, r = 253, g = 126, b = 0},
			}
		})
	end
	
	-- BGA,score,bpm,combo用フレーム
	table.insert(parts.destination,{
		id = "infoFrame", dst = {
			{x = base.infoPositionX, y = 209, w = 1350, h = 811},
		}
	})
	
	-- 現在のスコア
	table.insert(parts.destination,	{
		id = "nowscore", dst = {
			{x = base.infoPositionX + 250, y = 222, w = 28, h = 36},
		}
	})
	
	-- スコアの数字ぐるぐる
	do
		local num = 8
		local timer = {
			MAIN.TIMER.BOMB_1P_SCRATCH,
			MAIN.TIMER.BOMB_1P_KEY1,
			MAIN.TIMER.BOMB_1P_KEY2,
			MAIN.TIMER.BOMB_1P_KEY3,
			MAIN.TIMER.BOMB_1P_KEY4,
			MAIN.TIMER.BOMB_1P_KEY5,
			MAIN.TIMER.BOMB_1P_KEY6,
			MAIN.TIMER.BOMB_1P_KEY7
		}
		local duration = 400
		for i = 1, num, 1 do
			-- 1桁目
			table.insert(parts.destination, {
				id = "roulette_number_1", timer = timer[i], loop = -1, dst = {
					{time = 0, x = base.infoPositionX + 390, y = 222, w = 28, h = 36},
					{time = duration}
				}
			})
			-- 2桁目
			table.insert(parts.destination, {
				id = "roulette_number_2", timer = timer[i], loop = -1, dst = {
					{time = 0, x = base.infoPositionX + 362, y = 222, w = 28, h = 36},
					{time = duration}
				}
			})
			-- 3桁目
			table.insert(parts.destination, {
				id = "roulette_number_3", timer = timer[i], loop = -1, dst = {
					{time = 0, x = base.infoPositionX + 334, y = 222, w = 28, h = 36},
					{time = duration}
				}
			})
		end
	end
	
	-- 最大コンボ
	-- op331: 最大コンボ更新時
	table.insert(parts.destination,	{
		id = "maxcombo", dst = {
			{x = base.infoPositionX + 950, y = 222, w = 28, h = 36},
		}
	})
	-- bpm関連
	table.insert(parts.destination,	{
		id = "maxbpm", op = {MAIN.OP.BPMCHANGE}, dst = {
			{x = base.infoPositionX + 763, y = 232, w = 21, h = 27},
		}
	})
	table.insert(parts.destination,	{
		id = "nowbpm", dst = {
			{x = base.infoPositionX + 621, y = 232, w = 28, h = 36},
		}
	})
	table.insert(parts.destination,	{
		id = "minbpm", op = {MAIN.OP.BPMCHANGE}, dst = {
			{x = base.infoPositionX + 507, y = 232, w = 21, h = 27},
		}
	})
	
	do
		local posX
		local judgegraphPosX
		if PROPERTY.isInfoDisplayTypeA() then
			posX = 808
			judgegraphPosX = 832
		elseif PROPERTY.isInfoDisplayTypeB() then
			posX = 23
			judgegraphPosX = 47
		end
		-- 判定グラフ
		table.insert(parts.destination,{
			id = "infoNotesDistributionFrame", dst = {
				{x = base.infoPositionX + posX, y = 62, w = 519, h = 142},
			}
		})
		if PROPERTY.isnotesDistributionCoverOff() then
			table.insert(parts.destination,	{
				id = MAIN.IMAGE.BLACK, dst = {
					{time = 0, x = base.infoPositionX + judgegraphPosX, y = 71, w = 472, h = 107, a = 100}
				}
			})
			table.insert(parts.destination,	{
				id = "judgegraph", dst = {
					{time = 0, x = base.infoPositionX + judgegraphPosX, y = 71, w = 472, h = 107}
				}
			})
			table.insert(parts.destination,	{
				id = "bpmgraph", dst = {
					{time = 0, x = base.infoPositionX + judgegraphPosX, y = 71, w = 472, h = 107}
				}
			})
		elseif PROPERTY.isnotesDistributionCoverOn() then
			table.insert(parts.destination,	{
				id = "notesCover", dst = {
					{x = base.infoPositionX + posX, y = 62, w = 519, h = 140},
				}
			})
		end
			
		-- タイミンググラフ
		table.insert(parts.destination,{
			id = "infoJudgegraphFrame", dst = {
				{x = base.infoPositionX + posX , y = 4, w = 519, h = 54},
			}
		})
		if PROPERTY.isTiminggraphCoverOff() then
			if PROPERTY.isTiminggraphTypeA() then
				table.insert(parts.destination,	{
					id = "timing", dst = {
						{time = 0, x = base.infoPositionX + judgegraphPosX, y = 8, w = 472, h = 30}
					}
				})
			elseif PROPERTY.isTiminggraphTypeB() then
				table.insert(parts.destination, {
					id = "tgBFrame", dst = {
						{x = base.infoPositionX + judgegraphPosX, y = 8, w = 472, h = 30},
					}
				})
				table.insert(parts.destination, {
					id = "gra_fastRate", dst = {
						{x = base.infoPositionX + judgegraphPosX + 2, y = 10, w = 468, h = 26},
					}
				})
				table.insert(parts.destination, {
					id = "gra_slowRate", dst = {
						{x = base.infoPositionX + judgegraphPosX + 470, y = 10, w = -468, h = 26},
					}
				})
				table.insert(parts.destination, {
					id = "tgBFrame2", dst = {
						{x = base.infoPositionX + judgegraphPosX, y = 8, w = 472, h = 30},
					}
				})
			end
			-- judgetimingnum
			table.insert(parts.destination, {
				id = "judgeTimingNum", dst = {
					{x = base.infoPositionX + judgegraphPosX, y = 37, w = 27, h = 20},
				}
			})
			table.insert(parts.destination, {
				id = "judgeTimingNum", dst = {
					{x = base.infoPositionX + judgegraphPosX + 350, y = 37, w = 27, h = 20},
				}
			})
			-- タイミング調節ボタン
			table.insert(parts.destination, {
				id = "timingAdjustBtn", dst = {
					{x = base.infoPositionX + judgegraphPosX, y = 4, w = 519, h = 54},
				}
			})
		elseif PROPERTY.isTiminggraphCoverOn() then
			table.insert(parts.destination,	{
				id = "timingCover", dst = {
					{x = base.infoPositionX + posX, y = 4, w = 519, h = 54},
				}
			})
		end
	end
	
	-- BGA
	do
		if PROPERTY.isNoBGA() then
			-- soundonly画像
			table.insert(parts.destination,{
				id = "soundonly", op = {MAIN.OP.BGA}, timer = 41, blend = MAIN.BLEND.ADDITION, dst = {
					{x = base.infoPositionX + 376, y = 451, w = 600, h = 350}
				}
			})
		else
			local num
			local posX = {}
			local posY = {}
			local width
			local height
			if PROPERTY.isBgaPattern1_1() then
				num = 1
				posX = {316}
				posY = {290}
				width = 720
				height = 720
			elseif PROPERTY.isBgaPattern16_9() then
				num = 1
				posX = {36}
				posY = {290}
				width = 1280
				height = 720
			elseif PROPERTY.isBgaPattern1_1_x2() then
				num = 2
				posX = {43, 679}
				posY = {335, 335}
				width = 630
				height = 630
			elseif PROPERTY.isBgaPattern16_9_x4() then
				num = 4
				posX = {50, 679, 50, 679}
				posY = {297, 297, 652, 652}
				width = 624
				height = 351
			end
			-- 配置
			if PROPERTY.isBgaPattern16_9() then
				table.insert(parts.destination, {
					id = "bga", op = {MAIN.OP.BGA}, stretch = MAIN.STRETCH.FIT_OUTER_TRIMMED, dst = {
						{x = base.infoPositionX + 36, y = 290, w = 1280, h = 720, a = 100}
					}
				})
			end
			if PROPERTY.isBgaPattern16_9_x4() then
				for i = 1, num, 1 do
					table.insert(parts.destination, {
						id = "bga", op = {MAIN.OP.BGA}, stretch = MAIN.STRETCH.FIT_OUTER_TRIMMED, dst = {
							{x = base.infoPositionX + posX[i], y = posY[i], w = width, h = height, a = 100}
						}
					})
				end
			end
			for i = 1, num, 1 do
				table.insert(parts.destination, {
					id = "bga", op = {MAIN.OP.BGA}, dst = {
						{x = base.infoPositionX + posX[i], y = posY[i], w = width, h = height}
					}
				})
			end
		end
	end
	
	-- 汎用BGA
	-- op170: BGAなし
	-- op171: BGAあり
	if main_state.option(MAIN.OP.NO_BGA) and PROPERTY.isHanyoTypeMovie() then
		table.insert(parts.image,{
			id = "bga_hanyo", src = 23, x = 0, y = 0, w = 1280, h = 720
		})
		table.insert(parts.destination,	{
			id = "bga_hanyo", timer = 41, dst = {
				{x = base.infoPositionX + 36, y = 290, w = 1280, h = 720}
			}
		})
	elseif main_state.option(MAIN.OP.NO_BGA) and PROPERTY.isHanyoTypeImage() then
		table.insert(parts.image,{
			id = "bga_hanyo", src = 27, x = 0, y = 0, w = 1280, h = 720
		})
		table.insert(parts.destination,	{
			id = "bga_hanyo", timer = 41, dst = {
				{x = base.infoPositionX + 36, y = 290, w = 1280, h = 720}
			}
		})
	elseif main_state.option(MAIN.OP.NO_BGA) and PROPERTY.isHanyoDisable() then
		-- soundonly画像
		table.insert(parts.destination,{
			id = "soundonly", timer = 41, blend = MAIN.BLEND.ADDITION, dst = {
				{x = base.infoPositionX + 376, y = 451, w = 600, h = 350}
			}
		})
	end
		
	-- BGAの明るさ調節
	table.insert(parts.destination,	{
		id = MAIN.IMAGE.BLACK, offsets = {PROPERTY.offsetBgaBrightness.num}, dst = {
			{x = base.infoPositionX + 36, y = 290, w = 1280, h = 720, a = 0},
		}
	})
		
	-- エフェクターフレーム
	table.insert(parts.destination,	{
		id = "effecter_frame", dst = {
			{x = base.infoPositionX + 522, y = 279, w = 308, h = 37},
		}
	})
	if main_state.option(MAIN.OP.NO_LN) then
		table.insert(parts.destination,	{
			id = "effecter_nonactive", dst = {
				{x = base.infoPositionX + 563, y = 283, w = 227, h = 28}
			}
		})
		table.insert(parts.destination,	{
			id = "effecter_active", timer = MAIN.TIMER.RHYTHM, dst = {
				{time = 0, x = base.infoPositionX + 563, y = 283, w = 227, h = 28},
				{time = 1000, a = 50}
			}
		})
	elseif main_state.option(MAIN.OP.LN) then
		-- LNがある場合はエフェクターを変える
		table.insert(parts.destination,	{
			id = "btn-lnmode_nonactive", dst = {
				{x = base.infoPositionX + 563, y = 283, w = 227, h = 28}
			}
		})
		table.insert(parts.destination,	{
			id = "btn-lnmode_active", timer = MAIN.TIMER.RHYTHM, dst = {
				{time = 0, x = base.infoPositionX + 563, y = 283, w = 227, h = 28},
				{time = 1000, a = 50}
			}
		})
	end
		
	-- 修飾
	do
		local num = 2
		local posX = {38, 1164}
		for i = 1, num, 1 do
			table.insert(parts.destination,	{
				id = "lamp", dst = {
					{x = base.infoPositionX + posX[i], y = 180, w = 152, h = 108}
				}
			})
			-- 修飾（リズムタイマー）
			-- op240: ゲージが100%
			-- op976: ゲージMAXインジケータ表示あり
			if PROPERTY.isGaugeMaxIndicatorOn() then
				table.insert(parts.destination,	{
					id = "lamp_rhythm", timer = MAIN.TIMER.RHYTHM, op = {-MAIN.OP.GAUGE_1P_100}, dst = {
						{time = 0,x = base.infoPositionX + posX[i], y = 180, w = 152, h = 108},
						{time = 1000, a = 150}
					}
				})
				-- 修飾(ゲージMAX)
				table.insert(parts.destination,	{
					id = "lamp_maxgauge", timer = MAIN.TIMER.GAUGE_MAX_1P, dst = {
						{x = base.infoPositionX + posX[i], y = 180, w = 152, h = 108}
					}
				})
			end
		end
	end
	return parts
end

return {
	load = load
}