--[[
	レーンカバー、リフト、hiddenカバー
	@author : KASAKO
]]

local function load(base)
	local parts = {}
	
	parts.image = {
		{id = "gaugeFrame_1P", src = 1, x = 0, y = 861, w = 556, h = 69},
		-- レーンカバー
		{id = "lane_cover2", src = 17, x = 0, y = 0, w = 513, h = 853},
	}
	
	parts.slider = {
		-- レーンカバー
		{id = "lane_cover", src = 17, x = 0, y = 0, w = 513, h = 853, angle = MAIN.S_ANGLE.DOWN, range = 853, type = MAIN.SLIDER.LANECOVER},
	}
	
	-- disapearline : lift開始地点(判定位置)
	parts.liftCover = {
		{id = "lift_cover", src = 18, x = 0, y = 0, w = 513, h = 853, disapearLine = 227},
	}
	
	-- disapearline : hidden開始地点(判定位置)
	parts.hiddenCover = {
		-- hiddenは黒のドットで
		{id = "hidden_cover", src = 1, x = 0, y = 0, w = 1, h = 1, disapearLine = 227},
	}
	
	parts.value = {
		-- 緑数字
		{id = "greennumber", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_GREEN},
		{id = "greennumberLanecoverOn", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_GREEN_LANECOVER_ON},
		{id = "greennumberLanecoverOff", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_GREEN_LANECOVER_OFF},
		{id = "greennumberMainbpmLanecoverOn", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_GREEN_LANECOVER_ON},
		{id = "greennumberMainbpmLanecoverOff", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_GREEN_LANECOVER_OFF},
		-- 最低bpm時の緑数字
		{id = "greennumberMinbpmLanecoverOn", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM_DURATION_LANECOVER_ON, align = MAIN.N_ALIGN.RIGHT},
		-- 最高bpm時の緑数字
		{id = "greennumberMaxbpmLanecoverOn", src = 1, x = 1400, y = 161, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM_DURATION_LANECOVER_ON, align = MAIN.N_ALIGN.LEFT},
		-- 白数字
		{id = "duration", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION},
		{id = "durationLanecoverOn", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_LANECOVER_ON},
		{id = "durationLanecoverOff", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_LANECOVER_OFF},
		{id = "durationMainbpmLanecoverOn", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_LANECOVER_ON},
		{id = "durationMainbpmLanecoverOff", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_LANECOVER_OFF},
		{id = "durationMinbpmLanecoverOn", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM_DURATION_LANECOVER_ON},
		{id = "durationMinbpmLanecoverOff", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM_DURATION_LANECOVER_OFF},
		{id = "durationMaxbpmLanecoverOn", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM_DURATION_LANECOVER_ON},
		{id = "durationMaxbpmLanecoverOff", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM_DURATION_LANECOVER_OFF},
		-- レーンカバー下げ量（白数字）
		{id = "lanecoverNumber", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.LANECOVER1},
		-- リフト数値
		{id = "liftNumber", src = 1, x = 1400, y = 101, w = 270, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.LIFT1},
	}
	
	parts.destination = {}
	
	-- hidden y : disapearLine（lift開始点）- h
	table.insert(parts.destination, {
		id = "hidden_cover", dst = {
			{x = base.playsidePositionX + 3, y = -632, w = 513, h = 859},
		}
	})
	
	-- リフト y : disapearLine（lift開始点）- h
	table.insert(parts.destination, {
		id = "lift_cover", dst = {
			{x = base.playsidePositionX + 3, y = -632, w = 513, h = 859},
		}
	})
	
	-- レーンカバー
	table.insert(parts.destination,	{
		id = "lane_cover", dst = {
			{x = base.playsidePositionX + 3, y = 1080, w = 513, h = 853},
		}
	})
	
	-- op:270 スタートボタン押下時
	-- op:272 リフトあり
	-- op:177 BMP変更あり
	-- レーンカバー白数字
	table.insert(parts.destination,	{
		id = "lanecoverNumber", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
			{x = base.playsidePositionX + 90, y = 1090, w = 27, h = 20}
		}
	})
	
	-- レーンカバー緑数字
	table.insert(parts.destination,	{
		id = "greennumber", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
			{x = base.playsidePositionX + 260, y = 1090, w = 27, h = 20},
		}
	})
	
	-- レーンカバー緑数字最大・最小
	table.insert(parts.destination,	{
		id = "greennumberMinbpmLanecoverOn", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING, MAIN.OP.BPMCHANGE}, dst = {
			{x = base.playsidePositionX + 220, y = 1120, w = 21, h = 18},
		}
	})
	table.insert(parts.destination,	{
		id = "from", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING, MAIN.OP.BPMCHANGE}, dst = {
			{x = base.playsidePositionX + 320, y = 1117, w = 21, h = 18, r = 84,  g = 255, b = 0},
		}
	})
	table.insert(parts.destination,	{
		id = "greennumberMaxbpmLanecoverOn", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING, MAIN.OP.BPMCHANGE}, dst = {
			{x = base.playsidePositionX + 340, y = 1120, w = 21, h = 18},
		}
	})
	
	-- リフト白数字
	table.insert(parts.destination,	{
		id = "liftNumber", offset = MAIN.OFFSET.LIFT, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
			{x = base.playsidePositionX + 90, y = base.notesPositionY - 30, w = 27, h = 20},
		}
	})
	
	-- リフト緑数字
	table.insert(parts.destination,	{
		id = "greennumber", offset = MAIN.OFFSET.LIFT, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
			{x = base.playsidePositionX + 260, y = base.notesPositionY - 30, w = 27, h = 20},
		}
	})
	
	-- 曲終了時にレーンカバーを下ろす
	-- timer143: 最終ノートタイマー
	if PROPERTY.isFinishCoverOn() then
		table.insert(parts.destination,	{
			id = "lane_cover2", timer = MAIN.TIMER.ENDOFNOTE_1P, loop = 1000, dst = {
				{time = 0, x = base.playsidePositionX + 3, y = 1080, w = 513, h = 853},
				{time = 1000, y = 1080 - 853, acc = MAIN.ACC.DECELERATE}
			}
		})
	end
	
	return parts
end

return {
	load = load
}