--[[
	レーン・グローランプ
	@author : KASAKO
]]

local function load(base)
	local parts = {}
	
	parts.image = {
		-- レーン(1P2P共通)
		{id = "lane", src = 2, x = 0, y = 0, w = 519, h = 856},
		-- レーンの仕切り
		{id = "lane_1P", src = 2, x = 0, y = 860, w = 513, h = 10},
		{id = "lane_2P", src = 2, x = 0, y = 880, w = 513, h = 10},
		-- 判定ライン
		{id = "judge_line", src = 5, x = 0, y = 0, w = 513, h = 12},
		-- グローランプ
		{id = "glow", src = 9, x = 0, y = 0, w = 431, h = 48},
	}
	
	parts.destination = {}

	local glowHeight = COMMONFUNC.offsetGlowlampHeight(PROPERTY.offsetGlowlampHeight.height())
	local judgeHeight = COMMONFUNC.offsetJudgelineHeight(PROPERTY.offsetJudgelineHeight.height())
	local posx = {base.laneLeftPosX, base.laneRightPosX}

		-- レーン（基準点）
		table.insert(parts.destination,	{
			id = "lane", dst = {
				{x = base.laneLeftPosX, y = base.notesPositionY - 3, w = 519, h = 856}
			}
		})
		table.insert(parts.destination,	{
			id = "lane", dst = {
				{x = base.laneRightPosX, y = base.notesPositionY - 3, w = 519, h = 856}
			}
		})

		-- レーン仕切り
		-- op936: レーン表示あり
		table.insert(parts.destination,	{
			id = "lane_1P", loop = 1000, timer = MAIN.TIMER.READY, dst = {
				{time = 0, x = base.laneLeftPosX + 3, y = base.notesPositionY, w = 513, h = 1},
				{time = 1000, h = 853}
			}
		})
		table.insert(parts.destination,	{
			id = "lane_2P", loop = 1000, timer = MAIN.TIMER.READY, dst = {
				{time = 0, x = base.laneRightPosX + 3, y = base.notesPositionY, w = 513, h = 1},
				{time = 1000, h = 853}
			}
		})

		-- レーンの明るさ調節
		table.insert(parts.destination,	{
			id = MAIN.IMAGE.BLACK, offsets = {PROPERTY.offsetLaneBrightness.num}, dst = {
				{x = base.laneLeftPosX + 3, y = base.notesPositionY, w = 513, h = 854, a = 0},
			}
		})
		table.insert(parts.destination,	{
			id = MAIN.IMAGE.BLACK, offsets = {PROPERTY.offsetLaneBrightness.num}, dst = {
				{x = base.laneRightPosX + 3, y = base.notesPositionY, w = 513, h = 854, a = 0},
			}
		})

	for i = 1, 2, 1 do
		-- グローランプ
		-- op939: グローランプを表示する
		-- timer:140 RHYHM（1000を一拍とする）
		if PROPERTY.isGlowlampOn() then
			table.insert(parts.destination, {
				id = "glow", offset = MAIN.OFFSET.LIFT, timer = MAIN.TIMER.RHYTHM, blend = MAIN.BLEND.ADDITION, filter = MAIN.FILTER.ON, dst = {
					{time = 0, x = posx[i] + 3, y = base.notesPositionY + judgeHeight, w = 513, h = glowHeight, a = 255},
					{time = 1000, a = 0}
				}
			})
			-- 初期グロー
			table.insert(parts.destination,	{
				id = "glow", offset = MAIN.OFFSET.LIFT, blend = MAIN.BLEND.ADDITION, filter = MAIN.FILTER.ON, loop = 1500, dst = {
					{time = 1000, x = posx[i] + 3, y = base.notesPositionY + judgeHeight, w = 513, h = glowHeight, a = 0},
					{time = 1500, a = 120}
				}
			})
		end
		-- 判定ライン
		table.insert(parts.destination,	{
			id = "judge_line", loop = 1000, offset = MAIN.OFFSET.LIFT, dst = {
				{time = 500, x = posx[i] + 3 + (513 / 2), y = base.notesPositionY, w = 0, h = judgeHeight},
				{time = 1000, x = posx[i] + 3, w = 513}
			}
		})
	end

	return parts
end

return {
	load = load
}