--[[
	キー画像と対応するキーフラッシュを配置
	@author : KASAKO
--]]
local function createNumber()
	return math.random(50, 155)
end

local function load(base, mode)
	local parts = {}
	
	local keyflashNormalWidth = 67
	local keyflashNormalHeight = 73
	local keyflashScratchWidth = 92
	local keyflashScratchHeight = 92
	local blendType = MAIN.BLEND.ADDITION
	local whitePosY = 137
	local blackPosY = 147

	local flash = {}
	if mode == 10 then
		flash.leftTimer = {MAIN.TIMER.KEYON_1P_KEY1, MAIN.TIMER.KEYON_1P_KEY2, MAIN.TIMER.KEYON_1P_KEY3, MAIN.TIMER.KEYON_1P_KEY4, MAIN.TIMER.KEYON_1P_KEY5}
		flash.rightTimer = {MAIN.TIMER.KEYON_2P_KEY1, MAIN.TIMER.KEYON_2P_KEY2, MAIN.TIMER.KEYON_2P_KEY3, MAIN.TIMER.KEYON_2P_KEY4, MAIN.TIMER.KEYON_2P_KEY5}
		flash.leftPosX = {110, 167, 224, 281, 338}
		flash.rightPosX = {113, 170, 227, 284, 341}
		flash.num = 5
	elseif mode == 14 then
		flash.leftTimer = {MAIN.TIMER.KEYON_1P_KEY1, MAIN.TIMER.KEYON_1P_KEY2, MAIN.TIMER.KEYON_1P_KEY3, MAIN.TIMER.KEYON_1P_KEY4, MAIN.TIMER.KEYON_1P_KEY5, MAIN.TIMER.KEYON_1P_KEY6, MAIN.TIMER.KEYON_1P_KEY7}
		flash.rightTimer = {MAIN.TIMER.KEYON_2P_KEY1, MAIN.TIMER.KEYON_2P_KEY2, MAIN.TIMER.KEYON_2P_KEY3, MAIN.TIMER.KEYON_2P_KEY4, MAIN.TIMER.KEYON_2P_KEY5, MAIN.TIMER.KEYON_2P_KEY6, MAIN.TIMER.KEYON_2P_KEY7}
		flash.leftPosX = {110, 167, 224, 281, 338, 395, 452}
		flash.rightPosX = {-1, 56, 113, 170, 227, 284, 341}
		flash.num = 7
	end
	
	parts.image = {
		-- キー部分
		{id = "keyBg", src = 15, x = 0, y = 0, w = 408, h = 114},
		{id = "keyFrame", src = 15, x = 0, y = 114, w = 408, h = 114},
		-- 皿部分
		{id = "scratchBg", src = 15, x = 408, y = 0, w = 111, h = 114},
		{id = "scratchFrame", src = 15, x = 408, y = 114, w = 111, h = 114},
		{id = "scratchFrame2", src = 15, x = 408, y = 228, w = 111, h = 114},
		-- カバー部分
		{id = "keyCoverTop", src = 15, x = 0, y = 228, w = 408, h = 57},
		{id = "keyCoverBottom", src = 15, x = 0, y = 285, w = 408, h = 57},
		-- キーフラッシュ
		{id = "keyflash_n", src = 16, x = 0, y = 0, w = keyflashNormalWidth, h = keyflashNormalHeight},
		-- スクラッチ
		{id = "scratchImage", src = 30, x = 0, y = 0, w = keyflashScratchWidth, h = keyflashScratchHeight},
	}
	
	parts.destination = {}
	
	do
		local flashLeftTimer = flash.leftTimer
		local flashRightTimer = flash.rightTimer
		local flashLeftPosX = flash.leftPosX
		local flashRightPosX = flash.rightPosX

		local flashLeftPosY = {whitePosY, blackPosY, whitePosY, blackPosY, whitePosY, blackPosY, whitePosY}
		local flashRightPosY = {whitePosY, blackPosY, whitePosY, blackPosY, whitePosY, blackPosY, whitePosY}

		local red = createNumber()
		local green = createNumber()
		local blue = createNumber()
		local scratchTimer = {100, 110}
		local scratchflashPosX = {9, 509}

		local framePos = {
			keyBg = {base.laneLeftPosX + 111, base.laneRightPosX},
			keyFrame = {base.laneLeftPosX + 111, base.laneRightPosX},
			scratchBg = {base.laneLeftPosX, base.laneRightPosX + 408},
			scratchFrame = {base.laneLeftPosX, base.laneRightPosX + 408},
			scratchFrame2 = {base.laneLeftPosX, base.laneRightPosX + 408}
		}
		
		-- 1P2Pフレーム
		for i = 1, 2, 1 do
			table.insert(parts.destination,	{
				id = "keyBg", dst = {
					{x = framePos.keyBg[i], y = 110, w = 408, h = 114},
				}
			})
			table.insert(parts.destination,	{
				id = "keyFrame", dst = {
					{x = framePos.keyFrame[i], y = 110, w = 408, h = 114},
				}
			})
			table.insert(parts.destination,	{
				id = "scratchBg", dst = {
					{x = framePos.scratchBg[i], y = 110, w = 111, h = 114},
				}
			})
			table.insert(parts.destination,	{
				id = "scratchFrame", dst = {
					{x = framePos.scratchFrame[i], y = 110, w = 111, h = 114},
				}
			})
			table.insert(parts.destination,	{
				id = "scratchFrame2", loop = 1500, dst = {
					{time = 1000, x = framePos.scratchFrame2[i], y = 110, w = 111, h = 114, r = red, g = green, b = blue, a = 0},
					{time = 1500, a = 255}
				}
			})
			-- ロード完了後に光るように
			table.insert(parts.destination,	{
				id = "scratchFrame2", op = {MAIN.OP.LOADED, MAIN.OP.AUTOPLAYOFF},timer = scratchTimer[i], loop = -1, dst = {
					{time = 0, x = framePos.scratchFrame2[i], y = 110, w = 111, h = 114, r = red + 100, g = green + 100, b = blue + 100},
					{time = 50, a = 0}
				}
			})
			-- オート用
			table.insert(parts.destination,	{
				id = "scratchFrame2", op = {MAIN.OP.LOADED, MAIN.OP.AUTOPLAYON},timer = scratchTimer[i], dst = {
					{time = 0, x = framePos.scratchFrame2[i], y = 110, w = 111, h = 114, r = red + 100, g = green + 100, b = blue + 100},
					{time = 50, a = 0}
				}
			})
		end

		-- キーフラッシュ配置（鍵盤）
		for i = 1, flash.num, 1 do
			-- 左
			table.insert(parts.destination,	{
				id = "keyflash_n", timer = flashLeftTimer[i], blend = blendType, dst = {
					{x = base.laneLeftPosX + flashLeftPosX[i], y = flashLeftPosY[i], w = keyflashNormalWidth, h = keyflashNormalHeight},
				}
			})
			-- 右
			table.insert(parts.destination,	{
				id = "keyflash_n", timer = flashRightTimer[i], blend = blendType, dst = {
					{x = base.laneRightPosX + flashRightPosX[i], y = flashRightPosY[i], w = keyflashNormalWidth, h = keyflashNormalHeight},
				}
			})
		end

		-- 皿
		table.insert(parts.destination,	{
			id = "scratchImage", filter = MAIN.FILTER.ON, offset = MAIN.OFFSET.SCRATCHANGLE_1P, dst = {
				{x = base.laneLeftPosX + scratchflashPosX[1], y = 121, w = keyflashScratchWidth, h = keyflashScratchHeight},
			}
		})
		table.insert(parts.destination,	{
			id = "scratchImage", filter = MAIN.FILTER.ON, offset = MAIN.OFFSET.SCRATCHANGLE_2P, dst = {
				{x = base.laneRightPosX + scratchflashPosX[2], y = 121, w = -keyflashScratchWidth, h = keyflashScratchHeight},
			}
		})

		-- キーカバー
		table.insert(parts.destination, {
			id = "keyCoverTop", stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, loop = -1, dst = {
				{time = 0, x = base.laneLeftPosX + 112, y = 167, w = 408, h = 57, acc = MAIN.ACC.DECELERATE},
				{time = 1000},
				{time = 1300, y = 167 + 57, h = 0}
			}
		})
		table.insert(parts.destination, {
			id = "keyCoverTop", stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, loop = -1, dst = {
				{time = 0, x = base.laneRightPosX, y = 167, w = 408, h = 57, acc = MAIN.ACC.DECELERATE},
				{time = 1000},
				{time = 1300, y = 167 + 57, h = 0}
			}
		})
		table.insert(parts.destination, {
			id = "keyCoverBottom", stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, loop = -1, dst = {
				{time = 0, x = base.laneLeftPosX + 112, y = 110, w = 408, h = 57, acc = MAIN.ACC.DECELERATE},
				{time = 1000},
				{time = 1300, h = 0}
			}
		})
		table.insert(parts.destination, {
			id = "keyCoverBottom", stretch = MAIN.STRETCH.FIT_WIDTH_TRIMMED, loop = -1, dst = {
				{time = 0, x = base.laneRightPosX, y = 110, w = 408, h = 57, acc = MAIN.ACC.DECELERATE},
				{time = 1000},
				{time = 1300, h = 0}
			}
		})
	end
	return parts
end

return {
	load = load
}