--[[
	レーンカバー、リフト、hiddenカバー
	@author : KASAKO
]]

local function load(base)
	local parts = {}
	parts.image = {}
	parts.slider = {}

	-- レーンカバーを同期する場合は左に同期する
	if PROPERTY.isLanecoverSyncOn() then
		table.insert(parts.image, {
			id = "laneCoverLeft2", src = 17, x = 0, y = 0, w = 513, h = 853
		})
		table.insert(parts.image, {
			id = "laneCoverRight2", src = 17, x = 0, y = 0, w = 513, h = 853
		})
		table.insert(parts.slider, {
			id = "laneCoverLeft", src = 17, x = 0, y = 0, w = 513, h = 853, angle = MAIN.S_ANGLE.DOWN, range = 853, type = MAIN.SLIDER.LANECOVER
		})
		table.insert(parts.slider, {
			id = "laneCoverRight", src = 17, x = 0, y = 0, w = 513, h = 853, angle = MAIN.S_ANGLE.DOWN, range = 853, type = MAIN.SLIDER.LANECOVER
		})
	elseif PROPERTY.isLanecoverSyncOff() then
		table.insert(parts.image, {
			id = "laneCoverLeft2", src = 17, x = 0, y = 0, w = 513, h = 853
		})
		table.insert(parts.image, {
			id = "laneCoverRight2", src = 18, x = 0, y = 0, w = 513, h = 853
		})
		table.insert(parts.slider, {
			id = "laneCoverLeft", src = 17, x = 0, y = 0, w = 513, h = 853, angle = MAIN.S_ANGLE.DOWN, range = 853, type = MAIN.SLIDER.LANECOVER
		})
		table.insert(parts.slider, {
			id = "laneCoverRight", src = 18, x = 0, y = 0, w = 513, h = 853, angle = MAIN.S_ANGLE.DOWN, range = 853, type = MAIN.SLIDER.LANECOVER
		})
	end

	-- disapearline : lift開始地点(判定位置)
	parts.liftCover = {
		{id = "liftCoverLeft", src = 19, x = 0, y = 0, w = 513, h = 853, disapearLine = 227},
		{id = "liftCoverRight", src = 19, x = 0, y = 0, w = 513, h = 853, disapearLine = 227},
	}
	
	-- disapearline : hidden開始地点(判定位置)
	parts.hiddenCover = {
		-- hiddenは黒のドットで
		{id = "hiddenCoverLeft", src = 1, x = 0, y = 0, w = 1, h = 1, disapearLine = 227},
		{id = "hiddenCoverRight", src = 1, x = 0, y = 0, w = 1, h = 1, disapearLine = 227},
	}
	
	parts.value = {
		-- 緑数字
		{id = "greennumber", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_GREEN},
		{id = "greennumberLanecoverOn", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_GREEN_LANECOVER_ON},
		{id = "greennumberLanecoverOff", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_GREEN_LANECOVER_OFF},
		{id = "greennumberMainbpmLanecoverOn", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_GREEN_LANECOVER_ON},
		{id = "greennumberMainbpmLanecoverOff", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_GREEN_LANECOVER_OFF},
		-- 最低bpm時の緑数字
		{id = "greennumberMinbpmLanecoverOn", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM_DURATION_LANECOVER_ON, align = 0},
		-- 最高bpm時の緑数字
		{id = "greennumberMaxbpmLanecoverOn", src = 1, x = 720, y = 1160, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM_DURATION_LANECOVER_ON, align = 1},
		-- 白数字
		{id = "duration", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION},
		{id = "durationLanecoverOn", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_LANECOVER_ON},
		{id = "durationLanecoverOff", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.DURATION_LANECOVER_OFF},
		{id = "durationMainbpmLanecoverOn", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_LANECOVER_ON},
		{id = "durationMainbpmLanecoverOff", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAINBPM_DURATION_LANECOVER_OFF},
		{id = "durationMinbpmLanecoverOn", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM_DURATION_LANECOVER_ON},
		{id = "durationMinbpmLanecoverOff", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MINBPM_DURATION_LANECOVER_OFF},
		{id = "durationMaxbpmLanecoverOn", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM_DURATION_LANECOVER_ON},
		{id = "durationMaxbpmLanecoverOff", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.MAXBPM_DURATION_LANECOVER_OFF},
		-- レーンカバー下げ量（白数字）
		{id = "lanecoverNumber", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.LANECOVER1},
		-- リフト数値
		{id = "liftNumber", src = 1, x = 720, y = 1040, w = 240, h = 20, divx = 10, divy = 1, digit = 4, ref = MAIN.NUM.LIFT1},
	}
	
	parts.destination = {}
	
	local wd = {"Left", "Right"}
	local posx = {base.laneLeftPosX, base.laneRightPosX}
	for i = 1, 2, 1 do
		-- hidden y : disapearLine（lift開始点）- h
		table.insert(parts.destination, {
			id = "hiddenCover"..wd[i], dst = {
				{x = posx[i] + 3, y = -632, w = 513, h = 859},
			}
		})
		
		-- リフト y : disapearLine（lift開始点）- h
		table.insert(parts.destination, {
			id = "liftCover"..wd[i], dst = {
				{x = posx[i] + 3, y = -632, w = 513, h = 859},
			}
		})
		
		-- レーンカバー
		table.insert(parts.destination,	{
			id = "laneCover"..wd[i], dst = {
				{x = posx[i] + 3, y = 1080, w = 513, h = 853},
			}
		})

		-- レーンカバー白数字
		table.insert(parts.destination,	{
			id = "lanecoverNumber", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
				{x = posx[i] + 100, y = 1090, w = 24, h = 20}
			}
		})
		
		-- レーンカバー緑数字
		table.insert(parts.destination,	{
			id = "greennumber", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
				{x = posx[i] + 270, y = 1090, w = 24, h = 20},
			}
		})
		
		-- レーンカバー緑数字最大・最小
		table.insert(parts.destination,	{
			id = "greennumberMinbpmLanecoverOn", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING, MAIN.OP.BPMCHANGE}, dst = {
				{x = posx[i] + 225, y = 1120, w = 24, h = 20},
			}
		})
		table.insert(parts.destination,	{
			id = "from", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING, MAIN.OP.BPMCHANGE}, dst = {
				{x = posx[i] + 335, y = 1117, w = 24, h = 20, r = 84,  g = 255, b = 0},
			}
		})
		table.insert(parts.destination,	{
			id = "greennumberMaxbpmLanecoverOn", offset = MAIN.OFFSET.LANECOVER, op = {MAIN.OP.LANECOVER1_CHANGING, MAIN.OP.BPMCHANGE}, dst = {
				{x = posx[i] + 355, y = 1120, w = 24, h = 20},
			}
		})
		
		-- リフト白数字
		table.insert(parts.destination,	{
			id = "liftNumber", offset = MAIN.OFFSET.LIFT, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
				{x = posx[i] + 100, y = base.notesPositionY - 30, w = 24, h = 20},
			}
		})
		
		-- リフト緑数字
		table.insert(parts.destination,	{
			id = "greennumber", offset = MAIN.OFFSET.LIFT, op = {MAIN.OP.LANECOVER1_CHANGING}, dst = {
				{x = posx[i] + 270, y = base.notesPositionY - 30, w = 24, h = 20},
			}
		})
		
		-- 曲終了時にレーンカバーを下ろす
		if PROPERTY.isFinishCoverOn() then
			table.insert(parts.destination,	{
				id = "laneCover"..wd[i].."2", timer = MAIN.TIMER.ENDOFNOTE_1P, loop = 1000, dst = {
					{time = 0, x = posx[i] + 3, y = 1080, w = 513, h = 853},
					{time = 1000, y = 1080 - 853, acc = MAIN.ACC.DECELERATE}
				}
			})
		end
	end
	
	return parts
end

return {
	load = load
}